/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.MemoryMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Date;

public class Action_ImportGLI
extends Action_Base {
    protected String m_parentPath = "";
    protected String m_projectName = "";
    protected String m_projectPath = "";
    protected String m_traceTablePath = "";
    protected ArrayList<String> m_gliFileList = null;
    protected String m_units = "";
    protected String m_dimension = "";
    protected Grid3D_Conversion m_grid3D = new Grid3D_Conversion();
    protected Table_Abstract m_shotTable = new Table_Memory();
    protected HashMap_Integer m_shotHash = new HashMap_Integer();
    protected int m_shotIndex_ID;
    protected int m_shotIndex_PointNumber;
    protected int m_shotIndex_LineNumber;
    protected int m_shotIndex_PointIndex;
    protected int m_shotIndex_X;
    protected int m_shotIndex_Y;
    protected int m_shotIndex_Z;
    protected int m_shotIndex_Uphole;
    protected int m_shotIndex_Depth;
    protected Table_Abstract m_receiverTable = new Table_Memory();
    protected HashMap_Integer m_receiverHash = new HashMap_Integer();
    protected int m_receiverIndex_ID;
    protected int m_receiverIndex_PointNumber;
    protected int m_receiverIndex_LineNumber;
    protected int m_receiverIndex_PointIndex;
    protected int m_receiverIndex_X;
    protected int m_receiverIndex_Y;
    protected int m_receiverIndex_Z;
    protected Table_Abstract m_fileTable = new Table_Memory();
    protected int m_fileIndex_FileID;
    protected int m_fileIndex_Name;
    protected int m_fileIndex_Path;
    protected Table_Abstract m_traceTable = new Table_Memory();
    protected int m_traceIndex_Killed;
    protected int m_traceIndex_TraceID;
    protected int m_traceIndex_FileID;
    protected int m_traceIndex_ShotID;
    protected int m_traceIndex_RecID;
    protected int m_traceIndex_Inline;
    protected int m_traceIndex_Crossline;
    protected int m_traceIndex_Pick;
    protected long m_traceCount = 0L;
    protected TraceTable_Huge m_diskTable;
    protected int m_currentShotID;
    protected double m_currentShotX;
    protected double m_currentShotY;
    protected int m_fileID = 999;
    protected int m_traceID = 999;
    protected int m_shot_id = 999;

    public Action_ImportGLI() {
        this.Description = "Import GLI files";
        this.MemoryRequired = 1024;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected boolean prepareTables() {
        try {
            this.m_fileTable.setName("FileList");
            this.m_fileIndex_FileID = this.m_fileTable.column_append("FileID", DataType.Int);
            this.m_fileIndex_Name = this.m_fileTable.column_append("Name", DataType.Text);
            this.m_fileIndex_Path = this.m_fileTable.column_append("Directory", DataType.Text);
            this.m_traceTable.setName("Trace");
            this.m_traceIndex_Killed = this.m_traceTable.column_append("Killed", DataType.Int);
            this.m_traceIndex_TraceID = this.m_traceTable.column_append("TraceID", DataType.Int);
            this.m_traceIndex_FileID = this.m_traceTable.column_append("FileID", DataType.Int);
            this.m_traceIndex_ShotID = this.m_traceTable.column_append("ShotID", DataType.Int);
            this.m_traceIndex_RecID = this.m_traceTable.column_append("ReceiverID", DataType.Int);
            this.m_traceIndex_Inline = this.m_traceTable.column_append("Inline", DataType.Int);
            this.m_traceIndex_Crossline = this.m_traceTable.column_append("Crossline", DataType.Int);
            this.m_traceIndex_Pick = this.m_traceTable.column_append("FBP_User", DataType.Float);
            this.m_traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "TraceTable");
            this.m_diskTable = new TraceTable_Huge(this.m_traceTablePath, "Trace", this.m_traceTable, 8);
            this.m_receiverTable.setName("Receiver");
            this.m_receiverIndex_ID = this.m_receiverTable.column_append("ReceiverID", DataType.Int);
            this.m_receiverIndex_PointNumber = this.m_receiverTable.column_append("PointNumber", DataType.Int);
            this.m_receiverIndex_LineNumber = this.m_receiverTable.column_append("LineNumber", DataType.Int);
            this.m_receiverIndex_PointIndex = this.m_receiverTable.column_append("PointIndex", DataType.Int);
            this.m_receiverIndex_X = this.m_receiverTable.column_append("Easting", DataType.Double);
            this.m_receiverIndex_Y = this.m_receiverTable.column_append("Northing", DataType.Double);
            this.m_receiverIndex_Z = this.m_receiverTable.column_append("Elevation", DataType.Double);
            this.m_shotTable.setName("Shot");
            this.m_shotIndex_ID = this.m_shotTable.column_append("ShotID", DataType.Int);
            this.m_shotIndex_PointNumber = this.m_shotTable.column_append("PointNumber", DataType.Int);
            this.m_shotIndex_LineNumber = this.m_shotTable.column_append("LineNumber", DataType.Int);
            this.m_shotIndex_PointIndex = this.m_shotTable.column_append("PointIndex", DataType.Int);
            this.m_shotIndex_X = this.m_shotTable.column_append("Easting", DataType.Double);
            this.m_shotIndex_Y = this.m_shotTable.column_append("Northing", DataType.Double);
            this.m_shotIndex_Z = this.m_shotTable.column_append("Elevation", DataType.Double);
            this.m_shotIndex_Uphole = this.m_shotTable.column_append("UpholeTime", DataType.Double);
            this.m_shotIndex_Depth = this.m_shotTable.column_append("PointDepth", DataType.Double);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkDimension() {
        try {
            if (!this.Hasher.string_exists("Dimension")) {
                this.FailureReason = "Dimension not specified";
                this.Failed = true;
                return false;
            }
            this.m_dimension = this.Hasher.string_get("Dimension");
            if (!this.m_dimension.equalsIgnoreCase("3D")) {
                this.m_dimension = "2D";
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkUnits() {
        try {
            if (!this.Hasher.string_exists("Units")) {
                this.FailureReason = "Units not specified";
                this.Failed = true;
                return false;
            }
            this.m_units = this.Hasher.string_get("Units");
            if (!this.m_units.equalsIgnoreCase("Feet")) {
                this.m_units = "Meters";
            }
            double gridSize = Pecos.gridSize(this.m_units);
            this.m_grid3D.setBinSize(gridSize, gridSize);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkFiles() {
        try {
            if (!this.Hasher.stringList_exists("FileList")) {
                this.FailureReason = "GLI file list not specified";
                this.Failed = true;
                return false;
            }
            this.m_gliFileList = this.Hasher.stringList_get("FileList");
            if (this.m_gliFileList.size() < 1) {
                this.FailureReason = "No GLI files specified";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkParentPath() {
        try {
            if (!this.Hasher.string_exists("ParentPath")) {
                this.FailureReason = "Parent path not specified";
                this.Failed = true;
                return false;
            }
            this.m_parentPath = this.Hasher.string_get("ParentPath");
            if (!Tools_FileSystem.exists_path(this.m_parentPath)) {
                this.FailureReason = "Parent path not valid";
                this.Failed = true;
                return false;
            }
            String projectPath = this.m_parentPath + "/" + this.m_projectName;
            this.m_projectPath = this.m_parentPath + "/" + this.m_projectName + ".xtref";
            if (Tools_FileSystem.exists_path(this.m_projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            if (Tools_FileSystem.exists_path(projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkName() {
        try {
            if (!this.Hasher.string_exists("ProjectName")) {
                this.FailureReason = "ProjectName not specified";
                this.Failed = true;
                return false;
            }
            this.m_projectName = this.Hasher.string_get("ProjectName");
            if (this.m_projectName.length() <= 1) {
                this.FailureReason = "m_projectName name not valid";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            String driverName = "SQLITE";
            SharedApplicationData.singleton().setDatabaseDriver(driverName);
            if (!this.checkUnits()) {
                return false;
            }
            if (!this.checkDimension()) {
                return false;
            }
            if (!this.checkFiles()) {
                return false;
            }
            if (!this.checkName()) {
                return false;
            }
            if (!this.checkParentPath()) {
                return false;
            }
            String projectFolder = this.m_projectName + ".xtref";
            this.m_projectPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_parentPath, projectFolder);
            if (!this.prepareTables()) {
                return false;
            }
            this.m_currentShotID = -999999;
            this.m_currentShotX = -999999.0;
            this.m_currentShotY = -999999.0;
            int shot_line = 1000;
            for (String fileName : this.m_gliFileList) {
                if (this.Halt) continue;
                System.out.println("Start reading file " + fileName);
                this.importFile(shot_line, fileName, messageServer);
                ++shot_line;
            }
            System.out.println("Finished file import, call finishedAppending");
            MemoryMonitor.singleton().print_runtime("A");
            this.m_diskTable.finishedAppending(null);
            this.m_diskTable = null;
            messageServer.setMessage_Level1("Creating trace table indices");
            System.out.println("Call TraceTable_Huge_Wrapper");
            MemoryMonitor.singleton().print_runtime("B");
            TraceTable_Huge_Wrapper wrapper = new TraceTable_Huge_Wrapper(this.m_traceTablePath);
            messageServer.setMessage_Level1("Save tables");
            String versionsPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Versions");
            String currentPath = Tools_FileSystem.confirmSubDirectoryExists(versionsPath, "Default");
            this.m_fileTable.saveToPath(this.m_projectPath);
            String fileNameDB = currentPath + "/geometry.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(false, fileNameDB);
            long start = System.currentTimeMillis();
            System.out.println("Save m_shotTable");
            MemoryMonitor.singleton().print_runtime("C");
            db.createDatabaseTable(this.m_shotTable);
            db.appendTable(this.m_shotTable, 0);
            System.out.println("Save m_receiverTable");
            MemoryMonitor.singleton().print_runtime("D");
            db.createDatabaseTable(this.m_receiverTable);
            db.appendTable(this.m_receiverTable, 0);
            db.createDatabaseTable(this.m_fileTable);
            db.appendTable(this.m_fileTable, 0);
            long end = System.currentTimeMillis();
            System.out.println("stuff into disk database = " + Long.toString(end - start));
            db.addColumn("Shot", "Killed", DataType.Bool);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = FALSE", "Killed"));
            db.addColumn("Receiver", "Killed", DataType.Bool);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = FALSE", "Killed"));
            db.addColumn("Shot", "InitialElevation", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialElevation", "Elevation"));
            db.addColumn("Shot", "InitialEasting", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialEasting", "Easting"));
            db.addColumn("Shot", "InitialNorthing", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialNorthing", "Northing"));
            db.addColumn("Receiver", "InitialElevation", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialElevation", "Elevation"));
            db.addColumn("Receiver", "InitialEasting", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialEasting", "Easting"));
            db.addColumn("Receiver", "InitialNorthing", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialNorthing", "Northing"));
            String gridFile = this.m_projectPath + "/GridDefinition3D.xml";
            this.m_grid3D.save(gridFile);
            ParameterTree p = new ParameterTree();
            Date date = new Date();
            String dateCreated = date.toString();
            p.string_put("DriverName", driverName);
            p.string_put("Units", this.m_units);
            p.string_put("Dimension", this.m_dimension);
            p.bool_put("HasSeismic", false);
            p.bool_put("HasShots", true);
            p.bool_put("HasReceivers", true);
            p.int_put("ShotCount", this.m_shotTable.row_count());
            p.int_put("ReceiverCount", this.m_receiverTable.row_count());
            p.long_put("TraceCount", this.m_traceCount);
            p.string_put("Origin", "GLI");
            p.string_put("DateCreated", dateCreated);
            String paramFileName = this.m_projectPath + "/ProjectDescription.xml";
            p.save(paramFileName);
            db.closeConnection();
            db = null;
            System.gc();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected void importFile(int shot_line, String fileName, IProgressMonitor messageServer) {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            String tempFileName = Tools_FileSystem.convertToUnixFileName(fileName);
            File file = new File(tempFileName);
            ++this.m_fileID;
            int fileRow = this.m_fileTable.row_increment();
            this.m_fileTable.putInt(fileRow, this.m_fileIndex_FileID, this.m_fileID);
            this.m_fileTable.putString(fileRow, this.m_fileIndex_Name, file.getName());
            this.m_fileTable.putString(fileRow, this.m_fileIndex_Path, file.getParent());
            String shotToken = "shot";
            String traceToken = "trace";
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            while (line != null && !this.Halt) {
                ArrayList<String> tokens = Tools_Strings.tokenizer(line);
                if (tokens.size() >= 7 && tokens.get(0).equalsIgnoreCase(shotToken)) {
                    this.m_currentShotID = ++this.m_shot_id;
                    int shot_point = Integer.parseInt(tokens.get(1));
                    this.m_currentShotX = Double.parseDouble(tokens.get(2));
                    this.m_currentShotY = Double.parseDouble(tokens.get(3));
                    double z = Double.parseDouble(tokens.get(4));
                    double u = Double.parseDouble(tokens.get(5));
                    double t = Double.parseDouble(tokens.get(6));
                    int row = this.m_shotTable.row_increment();
                    this.m_shotTable.putInt(row, this.m_shotIndex_ID, this.m_shot_id);
                    this.m_shotTable.putInt(row, this.m_shotIndex_PointNumber, shot_point);
                    this.m_shotTable.putInt(row, this.m_shotIndex_LineNumber, shot_line);
                    this.m_shotTable.putInt(row, this.m_shotIndex_PointIndex, 1);
                    this.m_shotTable.putDouble(row, this.m_shotIndex_X, this.m_currentShotX);
                    this.m_shotTable.putDouble(row, this.m_shotIndex_Y, this.m_currentShotY);
                    this.m_shotTable.putDouble(row, this.m_shotIndex_Z, z);
                    this.m_shotTable.putDouble(row, this.m_shotIndex_Uphole, u);
                    this.m_shotTable.putDouble(row, this.m_shotIndex_Depth, t);
                    String s = String.format("%d traces, %d shots, %d receivers", this.m_traceCount, this.m_shotTable.row_count(), this.m_receiverTable.row_count());
                    messageServer.setMessage_Level1(s);
                }
                if (tokens.size() >= 6 && tokens.get(0).equalsIgnoreCase(traceToken)) {
                    int recID = Integer.parseInt(tokens.get(1));
                    double x = Double.parseDouble(tokens.get(2));
                    double y = Double.parseDouble(tokens.get(3));
                    double z = Double.parseDouble(tokens.get(4));
                    double pick = Double.parseDouble(tokens.get(5));
                    if (!this.m_receiverHash.containsKey(recID)) {
                        int row = this.m_receiverTable.row_increment();
                        this.m_receiverTable.putInt(row, this.m_receiverIndex_ID, recID);
                        this.m_receiverTable.putInt(row, this.m_receiverIndex_PointNumber, recID);
                        this.m_receiverTable.putInt(row, this.m_receiverIndex_LineNumber, 1);
                        this.m_receiverTable.putInt(row, this.m_receiverIndex_PointIndex, 1);
                        this.m_receiverTable.putDouble(row, this.m_receiverIndex_X, x);
                        this.m_receiverTable.putDouble(row, this.m_receiverIndex_Y, y);
                        this.m_receiverTable.putDouble(row, this.m_receiverIndex_Z, z);
                        this.m_receiverHash.put(recID, row);
                    }
                    double midx = 0.5 * (x + this.m_currentShotX);
                    double midy = 0.5 * (y + this.m_currentShotY);
                    this.m_grid3D.setWorldLocation(midx, midy);
                    int binX = this.m_grid3D.Inline;
                    int binY = this.m_grid3D.Crossline;
                    ++this.m_traceID;
                    int r = this.m_traceTable.row_increment();
                    this.m_traceTable.putInt(r, this.m_traceIndex_Killed, 0);
                    this.m_traceTable.putInt(r, this.m_traceIndex_TraceID, this.m_traceID);
                    this.m_traceTable.putInt(r, this.m_traceIndex_FileID, this.m_fileID);
                    this.m_traceTable.putInt(r, this.m_traceIndex_ShotID, this.m_currentShotID);
                    this.m_traceTable.putInt(r, this.m_traceIndex_RecID, recID);
                    this.m_traceTable.putInt(r, this.m_traceIndex_Inline, binX);
                    this.m_traceTable.putInt(r, this.m_traceIndex_Crossline, binY);
                    this.m_traceTable.putFloat(r, this.m_traceIndex_Pick, (float)pick);
                    if (this.m_traceTable.row_count() > 5000) {
                        this.m_diskTable.appendTable(this.m_traceTable);
                        this.m_traceTable.row_clear(false);
                    }
                    ++this.m_traceCount;
                }
                line = br.readLine();
            }
            if (this.m_traceTable.row_count() > 0) {
                this.m_diskTable.appendTable(this.m_traceTable);
                this.m_traceTable.row_clear(false);
            }
            br.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

