/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;

public class Action_ImportBinaryPickFiles
extends Action_Base {
    protected String m_parentPath = "";
    protected String m_projectName = "";
    protected String m_projectPath = "";
    protected String m_traceTablePath = "";
    protected int m_decimation = 1;
    protected String m_directory = "";
    protected String m_shotFileName = "";
    protected String m_recFileName = "";
    protected String m_traceFileName = "";
    protected String m_units = "";
    protected String m_dimension = "";
    protected Grid3D_Conversion m_grid3D = new Grid3D_Conversion();
    protected Table_Abstract m_shotTable = new Table_Memory();
    protected HashMap_Integer m_shotHash = new HashMap_Integer();
    protected int m_shotIndex_ID;
    protected int m_shotIndex_PointNumber;
    protected int m_shotIndex_LineNumber;
    protected int m_shotIndex_PointIndex;
    protected int m_shotIndex_X;
    protected int m_shotIndex_Y;
    protected int m_shotIndex_Z;
    protected int m_shotIndex_Uphole;
    protected int m_shotIndex_Depth;
    protected Table_Abstract m_receiverTable = new Table_Memory();
    protected HashMap_Integer m_receiverHash = new HashMap_Integer();
    protected int m_receiverIndex_ID;
    protected int m_receiverIndex_PointNumber;
    protected int m_receiverIndex_LineNumber;
    protected int m_receiverIndex_PointIndex;
    protected int m_receiverIndex_X;
    protected int m_receiverIndex_Y;
    protected int m_receiverIndex_Z;
    protected Table_Abstract m_traceTable = new Table_Memory();
    protected int m_traceIndex_Killed;
    protected int m_traceIndex_TraceID;
    protected int m_traceIndex_FileID;
    protected int m_traceIndex_IndexInFile;
    protected int m_traceIndex_ShotID;
    protected int m_traceIndex_RecID;
    protected int m_traceIndex_Inline;
    protected int m_traceIndex_Crossline;
    protected int m_traceIndex_Pick;
    protected long m_traceCount = 0L;
    protected TraceTable_Huge m_diskTable;
    protected int m_currentShotID;
    protected double m_currentShotX;
    protected double m_currentShotY;
    protected int m_fileID = 999;
    protected int m_traceID = 999;

    public Action_ImportBinaryPickFiles() {
        this.Description = "Import Binary Pick Files files";
        this.MemoryRequired = 1024;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected void importTable(Table_Abstract table, String fileName, HashMap_Integer map) throws Exception {
        try {
            String nameID = table.name() + "ID";
            int index_ID = table.column_append(nameID, DataType.Int);
            int index_PointNumber = table.column_append("PointNumber", DataType.Int);
            int index_LineNumber = table.column_append("LineNumber", DataType.Int);
            int index_PointIndex = table.column_append("PointIndex", DataType.Int);
            int index_Killed = table.column_append("Killed", DataType.Bool);
            int index_X = table.column_append("Easting", DataType.Double);
            int index_Y = table.column_append("Northing", DataType.Double);
            int index_Z = table.column_append("Elevation", DataType.Double);
            int index_Uphole = table.column_append("UpholeTime", DataType.Double);
            int index_Depth = table.column_append("PointDepth", DataType.Double);
            int index_Water = table.column_append("WaterDepth", DataType.Double);
            RandomAccessFile reader = new RandomAccessFile(fileName, "r");
            long numBytes = reader.length();
            long RowSizeInBytes = 72L;
            long numRows = numBytes / RowSizeInBytes;
            ByteBuffer buffer = ByteBuffer.allocate((int)numBytes);
            reader.read(buffer.array());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            boolean crap = false;
            for (int n = 0; n < (int)numRows; ++n) {
                int magic;
                if ((long)n > numRows - 3L) {
                    crap = true;
                }
                if ((magic = buffer.getInt()) != 90909) {
                    return;
                }
                int id = buffer.getInt();
                int r = table.row_increment();
                map.put(id, r);
                table.putInt(r, index_ID, id);
                table.putInt(r, index_PointNumber, buffer.getInt());
                table.putInt(r, index_LineNumber, buffer.getInt());
                table.putInt(r, index_PointIndex, buffer.getInt());
                table.putInt(r, index_Killed, buffer.getInt());
                table.putDouble(r, index_X, buffer.getDouble());
                table.putDouble(r, index_Y, buffer.getDouble());
                table.putDouble(r, index_Z, buffer.getDouble());
                table.putDouble(r, index_Depth, buffer.getDouble());
                table.putDouble(r, index_Uphole, buffer.getDouble());
                table.putDouble(r, index_Water, buffer.getDouble());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean prepareTables() {
        try {
            this.m_traceTable.setName("Trace");
            this.m_traceIndex_Killed = this.m_traceTable.column_append("Killed", DataType.Int);
            this.m_traceIndex_TraceID = this.m_traceTable.column_append("TraceID", DataType.Int);
            this.m_traceIndex_FileID = this.m_traceTable.column_append("FileID", DataType.Int);
            this.m_traceIndex_IndexInFile = this.m_traceTable.column_append("IndexInFile", DataType.Long);
            this.m_traceIndex_ShotID = this.m_traceTable.column_append("ShotID", DataType.Int);
            this.m_traceIndex_RecID = this.m_traceTable.column_append("ReceiverID", DataType.Int);
            this.m_traceIndex_Inline = this.m_traceTable.column_append("Inline", DataType.Int);
            this.m_traceIndex_Crossline = this.m_traceTable.column_append("Crossline", DataType.Int);
            this.m_traceIndex_Pick = this.m_traceTable.column_append("FBP_User", DataType.Float);
            this.m_traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "TraceTable");
            this.m_diskTable = new TraceTable_Huge(this.m_traceTablePath, "Trace", this.m_traceTable, 8);
            this.m_receiverTable.setName("Receiver");
            this.m_receiverIndex_ID = this.m_receiverTable.column_append("ReceiverID", DataType.Int);
            this.m_shotTable.setName("Shot");
            this.m_shotIndex_ID = this.m_shotTable.column_append("ShotID", DataType.Int);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkDimension() {
        try {
            if (!this.Hasher.string_exists("Dimension")) {
                this.FailureReason = "Dimension not specified";
                this.Failed = true;
                return false;
            }
            this.m_dimension = this.Hasher.string_get("Dimension");
            if (!this.m_dimension.equalsIgnoreCase("3D")) {
                this.m_dimension = "2D";
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkUnits() {
        try {
            if (!this.Hasher.string_exists("Units")) {
                this.FailureReason = "Units not specified";
                this.Failed = true;
                return false;
            }
            this.m_units = this.Hasher.string_get("Units");
            if (!this.m_units.equalsIgnoreCase("Feet")) {
                this.m_units = "Meters";
            }
            double gridSize = Pecos.gridSize(this.m_units);
            this.m_grid3D.setBinSize(gridSize, gridSize);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkFiles() {
        try {
            boolean ok;
            if (!this.Hasher.string_exists("Directory")) {
                this.FailureReason = "Path not specified";
                this.Failed = true;
                return false;
            }
            this.m_directory = this.Hasher.string_get("Directory");
            this.m_shotFileName = this.m_directory + "/shot.dat";
            this.m_recFileName = this.m_directory + "/rec.dat";
            this.m_traceFileName = this.m_directory + "/pick.dat";
            boolean bl = ok = Tools_FileSystem.exists_file(this.m_recFileName) && Tools_FileSystem.exists_file(this.m_shotFileName) && Tools_FileSystem.exists_file(this.m_traceFileName);
            if (!ok) {
                this.FailureReason = "Files not present";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkParentPath() {
        try {
            if (!this.Hasher.string_exists("ParentPath")) {
                this.FailureReason = "Parent path not specified";
                this.Failed = true;
                return false;
            }
            this.m_parentPath = this.Hasher.string_get("ParentPath");
            if (!Tools_FileSystem.exists_path(this.m_parentPath)) {
                this.FailureReason = "Parent path not valid";
                this.Failed = true;
                return false;
            }
            String projectPath = this.m_parentPath + "/" + this.m_projectName;
            this.m_projectPath = this.m_parentPath + "/" + this.m_projectName + ".xtref";
            if (Tools_FileSystem.exists_path(this.m_projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            if (Tools_FileSystem.exists_path(projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkName() {
        try {
            if (!this.Hasher.string_exists("ProjectName")) {
                this.FailureReason = "ProjectName not specified";
                this.Failed = true;
                return false;
            }
            this.m_projectName = this.Hasher.string_get("ProjectName");
            if (this.m_projectName.length() <= 1) {
                this.FailureReason = "m_projectName name not valid";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            String driverName = "HSQLDB";
            SharedApplicationData.singleton().setDatabaseDriver(driverName);
            if (!this.checkUnits()) {
                return false;
            }
            if (!this.checkDimension()) {
                return false;
            }
            if (!this.checkFiles()) {
                return false;
            }
            if (!this.checkName()) {
                return false;
            }
            if (!this.checkParentPath()) {
                return false;
            }
            this.m_decimation = this.Hasher.int_get("Decimation", 1);
            this.m_decimation = Math.max(this.m_decimation, 1);
            this.m_decimation = Math.min(this.m_decimation, 20);
            String projectFolder = this.m_projectName + ".xtref";
            this.m_projectPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_parentPath, projectFolder);
            if (!this.prepareTables()) {
                return false;
            }
            HashMap_Integer mapRec = new HashMap_Integer();
            HashMap_Integer mapShot = new HashMap_Integer();
            this.importTable(this.m_receiverTable, this.m_recFileName, mapRec);
            this.importTable(this.m_shotTable, this.m_shotFileName, mapShot);
            RandomAccessFile reader = new RandomAccessFile(this.m_traceFileName, "r");
            long numBytes = reader.length();
            long RowSizeInBytes = 12L;
            long numTraces = numBytes / RowSizeInBytes;
            long tracesPerChunk = 1000000L;
            ByteBuffer buffer = ByteBuffer.allocate((int)(12L * tracesPerChunk));
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (long counter = 0L; counter < numTraces; counter += tracesPerChunk) {
                long numToRead = tracesPerChunk;
                long numLeft = numTraces - counter;
                if (numToRead > numLeft) {
                    numToRead = numLeft;
                }
                if ((long)buffer.array().length != 12L * numToRead) {
                    buffer = ByteBuffer.allocate((int)(12L * numToRead));
                }
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                byte[] arr = buffer.array();
                reader.read(arr);
                buffer.rewind();
                for (int n = 0; n < (int)numToRead; ++n) {
                    int sid = buffer.getInt();
                    int rid = buffer.getInt();
                    float pick = buffer.getFloat();
                    if (n % this.m_decimation != 0 || !mapRec.containsKey(rid) || !mapShot.containsKey(sid)) continue;
                    int binX = 1000;
                    int binY = 1000;
                    ++this.m_traceID;
                    int r = this.m_traceTable.row_increment();
                    this.m_traceTable.putInt(r, this.m_traceIndex_Killed, 0);
                    this.m_traceTable.putInt(r, this.m_traceIndex_TraceID, this.m_traceID);
                    this.m_traceTable.putInt(r, this.m_traceIndex_FileID, 1000);
                    this.m_traceTable.putLong(r, this.m_traceIndex_IndexInFile, this.m_traceID);
                    this.m_traceTable.putInt(r, this.m_traceIndex_ShotID, sid);
                    this.m_traceTable.putInt(r, this.m_traceIndex_RecID, rid);
                    this.m_traceTable.putInt(r, this.m_traceIndex_Inline, binX);
                    this.m_traceTable.putInt(r, this.m_traceIndex_Crossline, binY);
                    this.m_traceTable.putFloat(r, this.m_traceIndex_Pick, pick);
                    if (this.m_traceTable.row_count() > 5000) {
                        this.m_diskTable.appendTable(this.m_traceTable);
                        this.m_traceTable.row_clear(false);
                    }
                    ++this.m_traceCount;
                }
                System.out.println("counter = " + counter);
            }
            this.m_diskTable.finishedAppending(null);
            this.m_diskTable = null;
            messageServer.setMessage_Level1("Creating trace table indices");
            TraceTable_Huge_Wrapper wrapper = new TraceTable_Huge_Wrapper(this.m_traceTablePath);
            messageServer.setMessage_Level1("Save tables");
            String versionsPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Versions");
            String currentPath = Tools_FileSystem.confirmSubDirectoryExists(versionsPath, "Default");
            String fileNameDB = currentPath + "/geometry.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(false, fileNameDB);
            long start = System.currentTimeMillis();
            db.createDatabaseTable(this.m_shotTable);
            db.appendTable(this.m_shotTable, 0);
            db.createDatabaseTable(this.m_receiverTable);
            db.appendTable(this.m_receiverTable, 0);
            long end = System.currentTimeMillis();
            System.out.println("stuff into disk database = " + Long.toString(end - start));
            db.addColumn("Shot", "Killed", DataType.Bool);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = FALSE", "Killed"));
            db.addColumn("Receiver", "Killed", DataType.Bool);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = FALSE", "Killed"));
            db.addColumn("Shot", "InitialElevation", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialElevation", "Elevation"));
            db.addColumn("Shot", "InitialEasting", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialEasting", "Easting"));
            db.addColumn("Shot", "InitialNorthing", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialNorthing", "Northing"));
            db.addColumn("Receiver", "InitialElevation", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialElevation", "Elevation"));
            db.addColumn("Receiver", "InitialEasting", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialEasting", "Easting"));
            db.addColumn("Receiver", "InitialNorthing", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialNorthing", "Northing"));
            String gridFile = this.m_projectPath + "/GridDefinition3D.xml";
            this.m_grid3D.save(gridFile);
            ParameterTree p = new ParameterTree();
            Date date = new Date();
            String dateCreated = date.toString();
            p.string_put("DriverName", driverName);
            p.string_put("Units", this.m_units);
            p.string_put("Dimension", this.m_dimension);
            p.bool_put("HasSeismic", false);
            p.bool_put("HasShots", true);
            p.bool_put("HasReceivers", true);
            p.int_put("ShotCount", this.m_shotTable.row_count());
            p.int_put("ReceiverCount", this.m_receiverTable.row_count());
            p.long_put("TraceCount", this.m_traceCount);
            p.string_put("Origin", "GLI");
            p.string_put("DateCreated", dateCreated);
            String paramFileName = this.m_projectPath + "/ProjectDescription.xml";
            p.save(paramFileName);
            db.closeConnection();
            db = null;
            System.gc();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

