/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Geometry.TableParser;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Seismic.CompressedSeismicFile;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_RMS;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid2D_Conversion_Line;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DefineGridDialog;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;

public class Action_AddSegyFilesToProject
extends Action_Base {
    public boolean Compressed = false;
    protected Table_Abstract m_shotTable;
    protected Table_Abstract m_receiverTable;
    protected TableParser m_shotParser;
    protected TableParser m_receiverParser;
    protected TraceTable_Huge_Wrapper m_traceTable;
    protected TraceTable_Huge m_diskTable;
    protected String m_projectPath;
    protected ArrayList<String> m_addFileList;
    protected ArrayList<Segy> m_addSegyList = new ArrayList();
    protected Table_Abstract m_fileTable;
    protected Table_Abstract m_segyTable;
    protected int m_fileIndex_FileID = -1;
    protected int m_fileIndex_Name = -1;
    protected int m_fileIndex_Path = -1;
    protected int m_segyIndex_Name = -1;
    protected int m_segyIndex_Path = -1;
    protected int m_fileID;
    protected Segy_Dictionary m_dict = new Segy_Dictionary();
    protected Grid3D_Conversion m_grid3D;
    protected long m_totalTracesAdded = 0L;
    protected long m_numRead = 0L;
    protected long m_newTraceCount = 0L;
    protected int m_channelMax = Integer.MIN_VALUE;
    protected int m_channelMin = Integer.MAX_VALUE;
    protected float[] m_inputData;
    protected float[] m_outputData;
    protected int m_inputSamplesPerTrace;
    protected float m_inputSampleInterval;
    protected int m_outputSamplesPerTrace;
    protected float m_outputSampleInterval;
    protected float m_maxTime;
    protected int m_inputSampleCount;
    protected int m_outputSampleCount;
    protected int m_samplesPerWindow = 10;
    protected int m_windowsPerTrace;
    protected int m_bytesPerWindow;
    protected int m_bytesPerTrace;
    protected long m_oldTraceCount;
    protected EnsembleWorker_RMS m_rms = new EnsembleWorker_RMS();
    protected CubicTraceInterpolator m_cti = new CubicTraceInterpolator();

    public Action_AddSegyFilesToProject() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Add SEGY files to existing project";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = true;
        this.DelayTimeDataModified = false;
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            if (!this.checkDict()) {
                return false;
            }
            if (!this.checkFiles()) {
                return false;
            }
            this.Compressed = RefractionStaticsProject.singleton().information().bool_get("HasCompressed", false);
            if (this.Compressed) {
                this.m_oldTraceCount = RefractionStaticsProject.singleton().traceTableWrapper().traceTable().rowCount();
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_projectPath = project.ParentProjectPath;
            if (!this.prepareTables()) {
                return false;
            }
            for (Segy segy : this.m_addSegyList) {
                if (this.Halt) continue;
                this.importFile(segy, messageServer);
            }
            this.m_diskTable.finishedAppending(null);
            RefractionStaticsProject.singleton().traceTableWrapper_Refresh();
            RefractionStaticsProject.singleton().traceTableWrapper().recreateIndexers();
            if (this.Halt) {
                this.FailureReason = "Import halted";
                this.Failed = true;
                return false;
            }
            this.m_fileTable.saveToPath(RefractionStaticsProject.singleton().projectPath());
            this.m_segyTable.saveToPath(RefractionStaticsProject.singleton().projectPath());
            this.populateDefaultTableValues(this.m_shotTable);
            this.populateDefaultTableValues(this.m_receiverTable);
            this.saveTablesToDisk();
            this.updateParameterTree();
            RefractionStaticsProject.singleton().reloadFileInfo(false);
            project.createDefaultGrid3D();
            if (project.dim2D()) {
                project.grid2DPrepDefault();
                Grid2D_Conversion_Line g2d = new Grid2D_Conversion_Line();
                g2d.setAngle(project.TempGrid2DAngle);
                g2d.setBinSize(project.TempGrid2DBinSize);
                g2d.setOrigin(project.TempGrid2DOriginX, project.TempGrid2DOriginY);
                project.setGrid2D_Conversion(g2d);
            }
            DefineGridDialog gridDialog = new DefineGridDialog(false, true);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean prepareTables() {
        try {
            String fileListPath = RefractionStaticsProject.singleton().projectPath() + "/";
            this.m_fileTable = Table_Memory.readTable(fileListPath, "FileList");
            if (this.m_fileTable == null) {
                throw new Exception("File list not found!");
            }
            this.m_fileID = 999 + this.m_fileTable.row_count();
            this.m_fileIndex_FileID = this.m_fileTable.column_indexOfColumn("FileID");
            this.m_fileIndex_Name = this.m_fileTable.column_indexOfColumn("Name");
            this.m_fileIndex_Path = this.m_fileTable.column_indexOfColumn("Directory");
            if (this.m_fileIndex_FileID < 0 || this.m_fileIndex_Name < 0 || this.m_fileIndex_Path < 0) {
                throw new Exception("Bad file list!");
            }
            String segyListName = "SegyList.xml";
            String segyListPath = RefractionStaticsProject.singleton().projectPath() + "/" + segyListName;
            if (!Tools_FileSystem.exists_file(segyListPath)) {
                throw new Exception("SEG-Y list not found!");
            }
            this.m_segyTable = Table_Memory.readTable(fileListPath, "SegyList");
            this.m_segyIndex_Name = this.m_segyTable.column_indexOfColumn("Name");
            this.m_segyIndex_Path = this.m_segyTable.column_indexOfColumn("Directory");
            this.m_shotTable = RefractionStaticsProject.singleton().shotTable();
            this.m_receiverTable = RefractionStaticsProject.singleton().receiverTable();
            this.m_shotParser = new TableParser(this.m_shotTable, false);
            this.m_receiverParser = new TableParser(this.m_receiverTable, false);
            String treePath = RefractionStaticsProject.singleton().projectPath() + "/ProjectDescription.xml";
            ParameterTree tree = new ParameterTree();
            tree.read(treePath);
            this.m_channelMax = tree.int_get("ChannelMax", this.m_channelMax);
            this.m_channelMin = tree.int_get("ChannelMin", this.m_channelMin);
            this.m_grid3D = RefractionStaticsProject.singleton().getEmptyGrid3D();
            String traceTablePath = RefractionStaticsProject.singleton().projectPath() + "/TraceTable";
            this.m_diskTable = new TraceTable_Huge(traceTablePath, "Trace");
            this.m_diskTable.createAppender();
            this.m_diskTable.seekToEnd();
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.FailureReason = ex.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkFiles() {
        try {
            if (!this.Hasher.stringList_exists("FileList")) {
                this.FailureReason = "SEG-Y file list not specified";
                this.Failed = true;
                return false;
            }
            this.m_addFileList = this.Hasher.stringList_get("FileList");
            this.m_addSegyList.clear();
            if (this.m_addFileList.size() < 1) {
                this.FailureReason = "No files to add";
                this.Failed = true;
                return false;
            }
            for (String filePath : this.m_addFileList) {
                boolean exists = false;
                String fileName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
                if (fileName.length() < 1) {
                    String tempFilePath = filePath.substring(0, filePath.length() - 1);
                    fileName = tempFilePath.substring(filePath.lastIndexOf("/"), tempFilePath.length());
                }
                String fileListPath = RefractionStaticsProject.singleton().projectPath() + "/";
                Table_Abstract fileTable = Table_Memory.readTable(fileListPath, "SegyList");
                int indexName = fileTable.column_indexOfColumn("Name");
                for (int r = 0; r < fileTable.row_count(); ++r) {
                    String name = fileTable.getString(r, indexName);
                    if (!name.equalsIgnoreCase(fileName)) continue;
                    exists = true;
                }
                Segy segy = new Segy();
                segy.setFileName(filePath);
                if (!segy.isFileOK() || exists) continue;
                segy.setSegyDictionary(this.m_dict);
                this.m_addSegyList.add(segy);
                this.m_totalTracesAdded += segy.traceCount();
            }
            if (this.m_addSegyList.size() < 1) {
                this.FailureReason = "No files to add";
                this.Failed = true;
                return false;
            }
            if (this.m_totalTracesAdded < 1L) {
                this.FailureReason = "No valid SEG-Y files specified";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkDict() {
        try {
            if (!this.Hasher.string_exists("DictionaryFile")) {
                this.FailureReason = "Dictionary file name not specified";
                this.Failed = true;
                return false;
            }
            String dictName = this.Hasher.string_get("DictionaryFile");
            this.m_dict.setOpenFileName(dictName);
            if (!this.m_dict.isFileNameValid()) {
                this.FailureReason = "Dictionary name not valid";
                this.Failed = true;
                return false;
            }
            if (!this.m_dict.isValidPreStack()) {
                this.FailureReason = "Not a valid pre-stack dictionary";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected void importFile(Segy segy, IProgressMonitor messageServer) {
        try {
            if (this.Halt) {
                return;
            }
            String tempFileName = Tools_FileSystem.convertToUnixFileName(segy.fileName());
            File file = new File(tempFileName);
            ++this.m_fileID;
            if (!this.Compressed) {
                int fileRow = this.m_fileTable.row_increment();
                this.m_fileTable.putInt(fileRow, this.m_fileIndex_FileID, this.m_fileID);
                this.m_fileTable.putString(fileRow, this.m_fileIndex_Name, file.getName());
                this.m_fileTable.putString(fileRow, this.m_fileIndex_Path, file.getParent());
            }
            int segyRow = this.m_segyTable.row_increment();
            this.m_segyTable.putString(segyRow, this.m_segyIndex_Name, file.getName());
            this.m_segyTable.putString(segyRow, this.m_segyIndex_Path, file.getParent());
            segy.setSegyDictionary(this.m_dict);
            Ensemble ensemble = new Ensemble();
            long numRead = 0L;
            int startIndex = 0;
            int tracesPerChunk = 2000;
            long[] indices = new long[tracesPerChunk];
            while ((long)startIndex < segy.traceCount() && !this.Halt) {
                int numValidIndices = 0;
                for (int i = 0; i < indices.length; ++i) {
                    indices[i] = i + startIndex;
                    if (indices[i] >= segy.traceCount()) continue;
                    ++numValidIndices;
                }
                ensemble.clearTraces(false);
                segy.populateEnsemble(ensemble, indices, indices.length, true, this.Compressed);
                this.m_rms.performWork(ensemble);
                ensemble = this.m_rms.output(0);
                if (ensemble.traceCount() > 1) {
                    this.mergeEnsemble(startIndex, ensemble);
                }
                this.m_numRead += (long)ensemble.traceCount();
                numRead += (long)ensemble.traceCount();
                String s = String.format("%d traces, %d shots, %d receivers", this.m_numRead, this.m_shotTable.row_count(), this.m_receiverTable.row_count());
                messageServer.setMessage_Level1(s);
                s = String.format("Number of geometry conflicts: %d shot, %d receiver", this.m_shotParser.totalConflicts(), this.m_receiverParser.totalConflicts());
                messageServer.setMessage_Level2(s);
                messageServer.setPercentDone(100.0 * (double)this.m_numRead / (double)this.m_totalTracesAdded);
                startIndex += tracesPerChunk;
            }
            if (this.Compressed) {
                this.m_oldTraceCount += numRead;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void mergeEnsemble(long startIndexInFile, Ensemble ensemble) {
        try {
            this.updateChannelRange(ensemble);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "Flags", 0, 0, 0);
            if (this.Compressed) {
                Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FileID", 0, 1000, 0);
            } else {
                Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FileID", 0, this.m_fileID, 0);
            }
            if (this.Compressed) {
                long startIndex = this.m_oldTraceCount + startIndexInFile;
                Tools_Ensemble.setHeaderLong(ensemble, "Trace", "IndexInFile", 0, startIndex, 1L);
            } else {
                Tools_Ensemble.setHeaderLong(ensemble, "Trace", "IndexInFile", 0, startIndexInFile, 1L);
            }
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "Killed", 0, 0, 0);
            this.m_shotParser.handleEnsemble(ensemble);
            this.m_receiverParser.handleEnsemble(ensemble);
            if (!this.m_dict.hasEntry("Trace", "FBP_User")) {
                Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_User", -9999.0f);
            }
            if (!ensemble.dictionary().containsEntry("Trace", "FBP_User")) {
                Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_User", -9999.0f);
            }
            Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_Back1", -9999.0f);
            Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_Back2", -9999.0f);
            Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_Back3", -9999.0f);
            Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_AMP", -9999.0f);
            Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_PickT", -9999.0f);
            Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_TAP", -9999.0f);
            Tools_Ensemble.computeInlineCrossline(ensemble, this.m_grid3D);
            int numAdded = this.m_diskTable.appendEnsemble(ensemble);
            if (this.Compressed) {
                this.prepareCompression(ensemble);
                this.appendCompressed(ensemble);
            }
            this.m_newTraceCount += (long)numAdded;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateChannelRange(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "Channel")) {
                return;
            }
            int index = ensemble.dictionary().getEntryIndex("Trace", "Channel");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int chan = ensemble.trace(n).header().getInt(index);
                this.m_channelMax = Math.max(this.m_channelMax, chan);
                this.m_channelMin = Math.min(this.m_channelMin, chan);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateParameterTree() {
        try {
            ParameterTree tree = RefractionStaticsProject.singleton().information();
            Date date = new Date();
            String dateString = date.toString();
            long oldTraceCount = tree.long_get("TraceCount");
            long totalTraceCount = oldTraceCount + this.m_newTraceCount;
            tree.string_put("DateModified", dateString);
            tree.int_put("ShotCount", this.m_shotTable.row_count());
            tree.int_put("ReceiverCount", this.m_receiverTable.row_count());
            tree.long_put("TraceCount", totalTraceCount);
            tree.int_put("ChannelMax", this.m_channelMax);
            tree.int_put("ChannelMin", this.m_channelMin);
            String paramFileName = RefractionStaticsProject.singleton().projectPath() + "/ProjectDescription.xml";
            tree.save(paramFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void saveTablesToDisk() {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().geometryDatabase();
            long start = System.currentTimeMillis();
            database.dropTable("Shot");
            database.createDatabaseTable(this.m_shotTable);
            database.appendTable(this.m_shotTable, 0);
            database.dropTable("Receiver");
            database.createDatabaseTable(this.m_receiverTable);
            database.appendTable(this.m_receiverTable, 0);
            database.dropTable("FileList");
            database.createDatabaseTable(this.m_fileTable);
            database.appendTable(this.m_fileTable, 0);
            database.dropTable("SegyList");
            database.createDatabaseTable(this.m_segyTable);
            database.appendTable(this.m_segyTable, 0);
            long end = System.currentTimeMillis();
            System.out.println("Stuff into disk database " + Long.toString(end - start));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void populateDefaultTableValues(Table_Abstract table) {
        try {
            int indexInitX = table.column_indexOfColumn("InitialEasting");
            int indexInitY = table.column_indexOfColumn("InitialNorthing");
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexZ = table.column_indexOfColumn("Elevation");
            int indexPolarity = -1;
            int indexTimeShift = -1;
            int indexPatternShiftTotal = -1;
            int indexFlag = -1;
            int indexVNSStackPickTime = -1;
            int indexVNSResidualError = -1;
            int indexVNSTotalError = -1;
            int indexEikStackPickTime = -1;
            int indexEikResidualError = -1;
            int indexEikTotalError = -1;
            if (table.column_exists("Polarity")) {
                indexPolarity = table.column_indexOfColumn("Polarity");
            }
            if (table.column_exists("TimeShift")) {
                indexTimeShift = table.column_indexOfColumn("TimeShift");
            }
            if (table.column_exists("PatternShiftTotal")) {
                indexPatternShiftTotal = table.column_indexOfColumn("PatternShiftTotal");
            }
            if (table.column_exists("Flag")) {
                indexFlag = table.column_indexOfColumn("Flag");
            }
            if (table.column_exists("TomoVNS_StackPickTime")) {
                indexVNSStackPickTime = table.column_indexOfColumn("TomoVNS_StackPickTime");
            }
            if (table.column_exists("TomoVNS_ResidualError")) {
                indexVNSResidualError = table.column_indexOfColumn("TomoVNS_ResidualError");
            }
            if (table.column_exists("TomoVNS_TotalError")) {
                indexVNSTotalError = table.column_indexOfColumn("TomoVNS_TotalError");
            }
            if (table.column_exists("Tomo3D_StackPickTime")) {
                indexEikStackPickTime = table.column_indexOfColumn("Tomo3D_StackPickTime");
            }
            if (table.column_exists("Tomo3D_ResidualError")) {
                indexEikResidualError = table.column_indexOfColumn("Tomo3D_ResidualError");
            }
            if (table.column_exists("Tomo3D_TotalError")) {
                indexEikTotalError = table.column_indexOfColumn("Tomo3D_TotalError");
            }
            for (int r = 0; r < table.row_count(); ++r) {
                double totalError;
                double residualError;
                double stackPickTime;
                double totalError2;
                double residualError2;
                double stackPickTime2;
                int flag;
                int patternShiftTotal;
                double timeShift;
                double polarity;
                double ix = table.getDouble(r, indexInitX);
                double iy = table.getDouble(r, indexInitY);
                if (ix < -900000.0) {
                    double x = table.getDouble(r, indexX);
                    table.putDouble(r, indexInitX, x);
                }
                if (iy < -900000.0) {
                    double y = table.getDouble(r, indexY);
                    table.putDouble(r, indexInitY, y);
                }
                if (table.column_exists("Polarity") && (polarity = table.getDouble(r, indexPolarity)) < -900000.0) {
                    table.putDouble(r, indexPolarity, 1.0);
                }
                if (table.column_exists("TimeShift") && (timeShift = table.getDouble(r, indexTimeShift)) < -900000.0) {
                    table.putDouble(r, indexTimeShift, 0.0);
                }
                if (table.column_exists("PatternShiftTotal") && (patternShiftTotal = table.getInt(r, indexPatternShiftTotal)) < -900000) {
                    table.putInt(r, indexPatternShiftTotal, 0);
                }
                if (table.column_exists("Flag") && (flag = table.getInt(r, indexFlag)) < -900000) {
                    table.putInt(r, indexFlag, 0);
                }
                if (table.column_exists("TomoVNS_StackPickTime") && (stackPickTime2 = table.getDouble(r, indexVNSStackPickTime)) < -900000.0) {
                    table.putDouble(r, indexVNSStackPickTime, 0.0);
                }
                if (table.column_exists("TomoVNS_ResidualError") && (residualError2 = table.getDouble(r, indexVNSResidualError)) < -900000.0) {
                    table.putDouble(r, indexVNSResidualError, 0.0);
                }
                if (table.column_exists("TomoVNS_TotalError") && (totalError2 = table.getDouble(r, indexVNSTotalError)) < -900000.0) {
                    table.putDouble(r, indexVNSTotalError, 0.0);
                }
                if (table.column_exists("Tomo3D_StackPickTime") && (stackPickTime = table.getDouble(r, indexEikStackPickTime)) < -900000.0) {
                    table.putDouble(r, indexEikStackPickTime, 0.0);
                }
                if (table.column_exists("Tomo3D_ResidualError") && (residualError = table.getDouble(r, indexEikResidualError)) < -900000.0) {
                    table.putDouble(r, indexEikResidualError, 0.0);
                }
                if (!table.column_exists("Tomo3D_TotalError") || !((totalError = table.getDouble(r, indexEikTotalError)) < -900000.0)) continue;
                table.putDouble(r, indexEikTotalError, 0.0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void appendCompressed(Ensemble ensemble) {
        try {
            if (ensemble.traceCount() < 1) {
                return;
            }
            int numBytesInOutputChunk = ensemble.traceCount() * this.m_bytesPerTrace;
            ByteBuffer outputBuffer = ByteBuffer_Shared.buffer(1, numBytesInOutputChunk);
            byte[] output = outputBuffer.array();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                FloatArrayWrapper wrapper = trace.data();
                if (this.m_inputData.length < wrapper.length()) {
                    this.m_inputData = new float[wrapper.length()];
                }
                wrapper.copyToArray(this.m_inputData);
                this.m_cti.prepareInput(this.m_inputData, 0.0f, this.m_inputSampleInterval);
                this.m_cti.interpolate(this.m_outputData, 0.0f, this.m_outputSampleInterval);
                int outputIndex = n * this.m_bytesPerTrace;
                float time0 = 0.0f;
                outputBuffer.putFloat(outputIndex, time0);
                outputIndex += 4;
                for (int w = 0; w < this.m_windowsPerTrace; ++w) {
                    float max = 1.0E-20f;
                    for (int s = 0; s < this.m_samplesPerWindow; ++s) {
                        float inputSample = this.m_outputData[s + w * this.m_samplesPerWindow];
                        max = Math.max(max, Math.abs(inputSample));
                    }
                    float scalar = 125.0f / max;
                    outputBuffer.putFloat(outputIndex, scalar);
                    outputIndex += 4;
                    for (int s = 0; s < this.m_samplesPerWindow; ++s) {
                        float inputSample = this.m_outputData[s + w * this.m_samplesPerWindow];
                        output[outputIndex++] = (byte)(scalar * inputSample);
                    }
                }
            }
            String path = RefractionStaticsProject.singleton().projectPath() + "/Data/" + RefractionStaticsProject.singleton().projectName() + "_data.sgy_wcf";
            RandomAccessFile dataRAF = new RandomAccessFile(path, "rw");
            long length = dataRAF.length();
            dataRAF.seek(length);
            dataRAF.write(outputBuffer.array(), 0, numBytesInOutputChunk);
            dataRAF.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prepareCompression(Ensemble ensemble) {
        try {
            int inputSamplesPerTrace = ensemble.trace(0).data().length();
            float inputSampleInterval = ensemble.trace(0).data().getSampleInterval();
            this.m_inputSamplesPerTrace = inputSamplesPerTrace;
            this.m_inputSampleInterval = inputSampleInterval;
            this.m_inputData = new float[this.m_inputSampleCount];
            if (this.m_inputSampleInterval < 0.1f) {
                this.m_inputSampleInterval = 0.1f;
            }
            CompressedSeismicFile file = new CompressedSeismicFile();
            String path = RefractionStaticsProject.singleton().projectPath() + "/Data/" + RefractionStaticsProject.singleton().projectName() + "_data.sgy_wcf";
            file.setFileName(path);
            this.m_outputSamplesPerTrace = file.samplesPerTrace();
            this.m_outputSampleInterval = file.sampleInterval();
            this.m_maxTime = (float)this.m_outputSamplesPerTrace * this.m_outputSampleInterval;
            if (this.m_maxTime < 0.0f) {
                this.m_maxTime = 0.0f;
            }
            this.m_outputSampleCount = (int)(0.5 + (double)(this.m_maxTime / this.m_outputSampleInterval));
            this.m_windowsPerTrace = this.m_outputSampleCount / this.m_samplesPerWindow;
            this.m_windowsPerTrace = Math.max(this.m_windowsPerTrace, 1);
            this.m_outputSampleCount = this.m_samplesPerWindow * this.m_windowsPerTrace;
            this.m_outputData = new float[this.m_outputSampleCount];
            this.m_bytesPerWindow = 4 + this.m_samplesPerWindow;
            this.m_bytesPerTrace = 4 + this.m_bytesPerWindow * this.m_windowsPerTrace;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

