/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Export;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Date;

public class Action_ExportSeisupMatrix
extends Action_Base {
    public String TraceColumnName = "";
    public String FileName = "";
    protected String m_formatD = "D %8d %8d";
    protected String m_formatVI = "V %12s";
    protected String m_formatVF = "V %12s";
    protected String m_formatE = "V";

    public Action_ExportSeisupMatrix() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Export SeisUP matrix file";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    protected BufferedWriter createWriter() {
        try {
            Date date = new Date();
            String dateCreated = date.toString();
            String s = String.format("* %s   3-14", this.TraceColumnName);
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.FileName));
            writer.write("****************************************");
            writer.newLine();
            writer.write("*             Flatirons export");
            writer.newLine();
            writer.write("*      " + dateCreated);
            writer.newLine();
            writer.write("*");
            writer.newLine();
            writer.write("* AREA  ?????           LINE  ????????? ");
            writer.newLine();
            writer.write("* NAME  Picks_01        TYPE  AFS1B ");
            writer.newLine();
            writer.write("*");
            writer.newLine();
            writer.write("*");
            writer.newLine();
            writer.write("* DIMENSIONS            COLUMNS ");
            writer.newLine();
            writer.write("* SLIN                   3 - 10");
            writer.newLine();
            writer.write("* SSPN                  12 - 19");
            writer.newLine();
            writer.write("*");
            writer.newLine();
            writer.write("* VECTORS               COLUMNS");
            writer.newLine();
            writer.write(s);
            writer.newLine();
            writer.write("*");
            writer.newLine();
            writer.write("****************************************");
            writer.newLine();
            return writer;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            int maxChan;
            String sql = "SELECT * FROM SHOT ORDER BY SSPN";
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (!project.traceTableWrapper().traceTable().column_exists("Channel")) {
                this.Failed = true;
                this.FailureReason = "Channel not presnt";
                return false;
            }
            if (!project.traceTableWrapper().traceTable().column_exists(this.TraceColumnName)) {
                this.Failed = true;
                this.FailureReason = "Channel not presnt";
                return false;
            }
            int colTraceValIndex = project.traceTableWrapper().traceTable().column_indexOfColumn(this.TraceColumnName);
            DataType type = project.traceTableWrapper().traceTable().column_type(colTraceValIndex);
            boolean isInt = type == DataType.Int || type == DataType.Short;
            int minChan = project.information().int_get("ChannelMin", -99999);
            if (minChan >= (maxChan = project.information().int_get("ChannelMax", -99999))) {
                this.Failed = true;
                this.FailureReason = "bad channels";
                return false;
            }
            Table_Abstract shotTable = project.geometryDatabase().extractTableDataUsingQuery("Shot", sql, 2000000);
            int colSSPN = shotTable.column_indexOfColumn("SSPN");
            int colLine = shotTable.column_indexOfColumn("LineNumber");
            int colPoint = shotTable.column_indexOfColumn("PointNumber");
            int colID = shotTable.column_indexOfColumn("ShotID");
            Ensemble ensemble = new Ensemble();
            BufferedWriter writer = this.createWriter();
            for (int n = 0; n < shotTable.row_count(); ++n) {
                int sspn = shotTable.getInt(n, colSSPN);
                int line = shotTable.getInt(n, colLine);
                int point = shotTable.getInt(n, colPoint);
                int shotID = shotTable.getInt(n, colID);
                ensemble.clearTraces(false);
                project.traceTableWrapper().populateEnsemble(ensemble, "ShotID", shotID, shotID);
                HashMap_Integer map = new HashMap_Integer();
                int indexChan = ensemble.dictionary().getEntryIndex("Trace", "Channel");
                int indexVal = ensemble.dictionary().getEntryIndex("Trace", this.TraceColumnName);
                int indexKilled = -9999;
                if (ensemble.dictionary().containsEntry("Trace", "Killed")) {
                    indexKilled = ensemble.dictionary().getEntryIndex("Trace", "Killed");
                }
                writer.write(String.format(this.m_formatD, line, sspn));
                writer.newLine();
                for (int t = 0; t < ensemble.traceCount(); ++t) {
                    int chan = ensemble.trace(t).header().getInt(indexChan);
                    map.put(chan, t);
                }
                for (int chan = minChan; chan <= maxChan; ++chan) {
                    boolean done = false;
                    if (map.containsKey(chan)) {
                        int v;
                        boolean killed = false;
                        int t = map.get(chan);
                        EnsembleTrace trace = ensemble.trace(t);
                        if (indexKilled >= 0) {
                            killed = trace.header().getBool(indexKilled);
                        }
                        if (!killed && (v = ensemble.trace(t).header().getInt(indexVal)) > -9998) {
                            writer.write(String.format(this.m_formatVI, Integer.toString(v)));
                            writer.newLine();
                            done = true;
                        }
                    }
                    if (done) continue;
                    writer.write(String.format(this.m_formatE, new Object[0]));
                    writer.newLine();
                }
                messageServer.setPercentDone(100.0 * (double)n / (double)shotTable.row_count());
            }
            writer.close();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    protected void justReadFromNode() {
    }
}

