/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.DelayTime.WaterBottomCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.util.Set;

public class Action_TableDataV2 {
    public int MaxBranch;
    public HashMap_Integer Map;
    public Table_Abstract Table;
    public int[] ID = new int[10];
    protected int[] IndexDT = new int[10];
    protected int[] IndexDTAnisAz = new int[10];
    protected int[] IndexDTAnisMag = new int[10];
    protected int[] IndexVel = new int[10];
    public int[] IndexError = new int[10];
    public int[] IndexCount = new int[10];
    public int IndexErrorTotal;
    public int IndexV0;
    public int IndexUphole = -9999;
    public int IndexDepth = -9999;
    public int IndexWaterDepth = -9999;
    public int IndexKilled;
    public int IndexID;
    public int IndexX;
    public int IndexY;
    public int IndexZ;
    public double[] X;
    public double[] Y;
    public double[] Z;
    public double[] WaterDepth;
    public double[] Uphole;
    public double[] Depth;
    public boolean[] Alive;
    protected float[][] m_velocity;
    protected float[][] m_delayTime;
    protected float[][] m_delayTimeAnisAz;
    protected float[][] m_delayTimeAnisMag;
    public float[][] UpholeCorrectionTime;
    public float[][] WaterBottomCorrectionTime;
    public float[][] ErrorSum;
    public float[][] WeightSum;
    public float[][] UpdateSum;
    public float[][] Count;
    public float[][] SlopeSumW;
    public float[][] SlopeSumX;
    public float[][] SlopeSumXX;
    public float[][] SlopeSumXV;
    public float[][] SlopeSumV;
    public boolean[][] SlopeValid;
    public boolean Modified_DelayTimeAnisotropy = false;
    public boolean Modified_DelayTime = false;
    public boolean Modified_Velocity = false;
    public boolean Modified_Count = false;
    public boolean Modified_Error = false;
    public float MinimumCount = 0.0f;
    public float MaximumCount = 0.0f;
    public double SumTop = 0.0;
    public double SumBottom = 0.0;
    public double RadiusSquared = 250000.0;

    public Action_TableDataV2(Table_Abstract table, HashMap_Integer map, int maxBranch) {
        try {
            int row;
            this.Map = map;
            this.Table = table;
            this.MaxBranch = maxBranch;
            this.IndexID = this.Table.column_indexOfColumn(table.name() + "ID");
            this.IndexX = this.Table.column_indexOfColumn("Easting");
            this.IndexY = this.Table.column_indexOfColumn("Northing");
            this.IndexZ = this.Table.column_indexOfColumn("Elevation");
            this.IndexWaterDepth = -9999;
            if (this.Table.column_exists("WaterDepth")) {
                this.IndexWaterDepth = this.Table.column_indexOfColumn("WaterDepth");
            }
            this.IndexUphole = -9999;
            if (this.Table.column_exists("UpholeTime")) {
                this.IndexUphole = this.Table.column_indexOfColumn("UpholeTime");
            }
            this.IndexDepth = -9999;
            if (this.Table.column_exists("PointDepth")) {
                this.IndexDepth = this.Table.column_indexOfColumn("PointDepth");
            }
            this.IndexKilled = this.Table.column_indexOfColumn("Killed");
            this.SlopeSumW = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.SlopeSumX = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.SlopeSumXX = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.SlopeSumXV = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.SlopeSumV = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.SlopeValid = new boolean[this.Table.row_count()][this.MaxBranch + 1];
            this.Count = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.ErrorSum = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.WeightSum = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.m_delayTime = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.m_delayTimeAnisAz = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.m_delayTimeAnisMag = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.m_velocity = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.UpdateSum = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.UpholeCorrectionTime = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.WaterBottomCorrectionTime = new float[this.Table.row_count()][this.MaxBranch + 1];
            this.ID = new int[this.Table.row_count()];
            this.X = new double[this.Table.row_count()];
            this.Y = new double[this.Table.row_count()];
            this.Z = new double[this.Table.row_count()];
            this.WaterDepth = new double[this.Table.row_count()];
            this.Depth = new double[this.Table.row_count()];
            this.Uphole = new double[this.Table.row_count()];
            this.Alive = new boolean[this.Table.row_count()];
            for (row = 0; row < this.Table.row_count(); ++row) {
                this.ID[row] = this.Table.getInt(row, this.IndexID);
                this.X[row] = this.Table.getDouble(row, this.IndexX);
                this.Y[row] = this.Table.getDouble(row, this.IndexY);
                this.Z[row] = this.Table.getDouble(row, this.IndexZ);
                this.Alive[row] = !this.Table.getBool(row, this.IndexKilled);
                this.WaterDepth[row] = 0.0;
                if (this.IndexWaterDepth >= 0) {
                    this.WaterDepth[row] = this.Table.getDouble(row, this.IndexWaterDepth);
                }
                this.WaterDepth[row] = Math.max(this.WaterDepth[row], 0.0);
                this.Uphole[row] = 0.0;
                if (this.IndexUphole >= 0) {
                    this.Uphole[row] = this.Table.getDouble(row, this.IndexUphole);
                }
                this.Uphole[row] = Math.max(this.Uphole[row], 0.0);
                this.Depth[row] = 0.0;
                if (this.IndexDepth >= 0) {
                    this.Depth[row] = this.Table.getDouble(row, this.IndexDepth);
                }
                this.Depth[row] = Math.max(this.Depth[row], 0.0);
            }
            this.IndexDT = new int[this.MaxBranch + 1];
            this.IndexDTAnisAz = new int[this.MaxBranch + 1];
            this.IndexDTAnisMag = new int[this.MaxBranch + 1];
            this.IndexVel = new int[this.MaxBranch + 1];
            this.IndexCount = new int[this.MaxBranch + 1];
            this.IndexError = new int[this.MaxBranch + 1];
            for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                int row2;
                String colNameDT = Pecos.getColNameDT(branch);
                String colNameDTAnisAz = Pecos.getColNameDtAnisAz(branch);
                String colNameDTAnisMag = Pecos.getColNameDtAnisMag(branch);
                String colNameVel = Pecos.getColNameVel(branch);
                String colNameErrorDT = Pecos.getColNameError(branch);
                String colNameCountDT = Pecos.getColNameCount(branch);
                this.IndexCount[branch] = this.Table.column_append(colNameCountDT, DataType.Int);
                this.IndexError[branch] = this.Table.column_append(colNameErrorDT, DataType.Double);
                this.IndexDT[branch] = this.Table.column_append(colNameDT, DataType.Double);
                this.IndexDTAnisAz[branch] = this.Table.column_append(colNameDTAnisAz, DataType.Double);
                this.IndexDTAnisMag[branch] = this.Table.column_append(colNameDTAnisMag, DataType.Double);
                this.IndexVel[branch] = this.Table.column_append(colNameVel, DataType.Double);
                for (row2 = 0; row2 < this.Table.row_count(); ++row2) {
                    this.WaterBottomCorrectionTime[row2][branch] = 0.0f;
                }
                for (row2 = 0; row2 < this.Table.row_count(); ++row2) {
                    this.UpholeCorrectionTime[row2][branch] = 0.0f;
                }
                for (row2 = 0; row2 < this.Table.row_count(); ++row2) {
                    this.m_delayTime[row2][branch] = 0.0f;
                }
            }
            this.IndexVel[0] = -9999;
            if (this.Table.column_exists(Pecos.getColNameVel(0))) {
                this.IndexVel[0] = this.Table.column_indexOfColumn(Pecos.getColNameVel(0));
            }
            for (row = 0; row < this.Table.row_count(); ++row) {
                for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                    double delayTime = Math.max(0.0, this.Table.getDouble(row, this.IndexDT[branch]));
                    this.m_delayTime[row][branch] = (float)delayTime;
                    double delayTimeAnisAz = this.Table.getDouble(row, this.IndexDTAnisAz[branch]);
                    this.m_delayTimeAnisAz[row][branch] = (float)delayTimeAnisAz;
                    double delayTimeAnisMag = Math.max(0.0, this.Table.getDouble(row, this.IndexDTAnisMag[branch]));
                    this.m_delayTimeAnisMag[row][branch] = (float)delayTimeAnisMag;
                    double vel = Math.max(500.0, this.Table.getDouble(row, this.IndexVel[branch]));
                    this.m_velocity[row][branch] = (float)vel;
                }
                if (this.IndexVel[0] >= 0) {
                    double vel = Math.max(500.0, this.Table.getDouble(row, this.IndexVel[0]));
                    this.m_velocity[row][0] = (float)vel;
                    continue;
                }
                this.m_velocity[row][0] = 0.4f * this.m_velocity[row][1];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setDelayTime(int branch, int row, float dt) throws Exception {
        try {
            this.m_delayTime[row][branch] = Math.max(dt, 0.1f);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setDelayTimeAnisAz(int branch, int row, float az) throws Exception {
        try {
            this.m_delayTimeAnisAz[row][branch] = az;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setDelayTimeAnisMag(int branch, int row, float mag) throws Exception {
        try {
            this.m_delayTimeAnisMag[row][branch] = Math.max(mag, 0.0f);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float getVelocity(int branch, int row) throws Exception {
        try {
            return this.m_velocity[row][branch];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float getDelayTime(int branch, int row) throws Exception {
        try {
            return this.m_delayTime[row][branch];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float getDelayTime(int branch, int row, double azimuth, boolean useAnisTerm, boolean useDipTerm) throws Exception {
        try {
            if (!useAnisTerm) {
                return this.m_delayTime[row][branch];
            }
            float dt = this.m_delayTime[row][branch];
            float dtAnisAz = this.m_delayTimeAnisAz[row][branch];
            float dtAnisMag = this.m_delayTimeAnisMag[row][branch];
            double anis = (double)dtAnisMag * Math.cos(2.0 * (azimuth - (double)dtAnisAz));
            return dt + (float)anis;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void extractDelayTimeFromInterpGrid(Grid3D grid, int branch) {
        try {
            for (int row = 0; row < this.Table.row_count(); ++row) {
                this.m_delayTime[row][branch] = grid.getNearestValue(this.X[row], this.Y[row]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addDelayTimeToInterpGrid(Grid3D grid, int branch) {
        try {
            for (int row = 0; row < this.Table.row_count(); ++row) {
                if (!(this.Count[row][branch] > 0.5f)) continue;
                grid.interp_Add(this.X[row], this.Y[row], this.m_delayTime[row][branch], 1.0f);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void ensureVelocityIncrease() {
        try {
            for (int row = 0; row < this.Table.row_count(); ++row) {
                for (int branch = 2; branch <= this.MaxBranch; ++branch) {
                    double v2 = this.m_velocity[row][branch];
                    double v1 = this.m_velocity[row][branch - 1];
                    if (!(v2 < v1 + 10.0)) continue;
                    this.m_velocity[row][branch] = this.m_velocity[row][branch - 1] + 10.0f;
                    this.Modified_Velocity = true;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void shiftDelayTimes(int branch, double shift) {
        try {
            for (int row = 0; row < this.Table.row_count(); ++row) {
                this.m_delayTime[row][branch] = this.m_delayTime[row][branch] + (float)shift;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double computeAverageDelayTime(int branch) {
        try {
            double sum1 = 0.0;
            double sum2 = 1.0E-20;
            for (int row = 0; row < this.Table.row_count(); ++row) {
                double delayTime = this.m_delayTime[row][branch];
                double count = this.Count[row][branch];
                sum1 += delayTime * count;
                sum2 += count;
            }
            return sum1 / sum2;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public void ensureDelayTimesIncrease() {
        try {
            for (int row = 0; row < this.Table.row_count(); ++row) {
                for (int branch = 2; branch <= this.MaxBranch; ++branch) {
                    double delayTime2 = this.m_delayTime[row][branch];
                    double delayTime1 = this.m_delayTime[row][branch - 1];
                    if (!(delayTime2 < delayTime1 + 1.0)) continue;
                    this.m_delayTime[row][branch] = this.m_delayTime[row][branch - 1] + 1.0f;
                    this.Modified_DelayTime = true;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void findCountRange(int branch) {
        try {
            this.MinimumCount = Float.MAX_VALUE;
            this.MaximumCount = 0.0f;
            for (int row = 0; row < this.Table.row_count(); ++row) {
                if (this.Alive[row]) {
                    float c = this.Count[row][branch];
                    this.MinimumCount = Math.min(this.MinimumCount, c);
                    this.MaximumCount = Math.max(this.MaximumCount, c);
                    continue;
                }
                this.MinimumCount = 0.0f;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeInterpolatedDelayTime(double x, double y, float minValidCount, int branch) {
        try {
            this.SumBottom = 1.0E-60;
            this.SumTop = 0.0;
            double rad = this.RadiusSquared;
            for (int row = 0; row < this.Table.row_count(); ++row) {
                float c = this.Count[row][branch];
                if (!(c >= minValidCount) || !this.Alive[row]) continue;
                double dx = x - this.X[row];
                double dy = y - this.Y[row];
                double distSquared = dx * dx + dy * dy;
                double w1 = this.RadiusSquared / (this.RadiusSquared + distSquared);
                double weight = w1 * w1;
                double v = this.m_delayTime[row][branch];
                this.SumTop += weight * v;
                this.SumBottom += weight;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeResiduals(boolean shot, int iteration) throws Exception {
        try {
            float changeFraction = 1.0f;
            if (shot && iteration == 1) {
                changeFraction = 0.5f;
            }
            for (int row = 0; row < this.Table.row_count(); ++row) {
                float count = this.Count[row][1];
                float desiredResidual = this.UpdateSum[row][1] / this.WeightSum[row][1];
                float change = desiredResidual - this.m_delayTime[row][1];
                change = changeFraction * change;
                this.m_delayTime[row][1] = this.m_delayTime[row][1] + change;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeDelayTimeUsingArrays(int iteration) throws Exception {
        try {
            float changeFraction = 0.7f;
            int numBad = 0;
            for (int row = 0; row < this.Table.row_count(); ++row) {
                for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                    boolean bad;
                    float count = this.Count[row][branch];
                    float desiredDelayTime = this.UpdateSum[row][branch] / this.WeightSum[row][branch];
                    boolean bl = bad = Float.isInfinite(desiredDelayTime) || Float.isNaN(desiredDelayTime);
                    if (!bad) {
                        float change = desiredDelayTime - this.m_delayTime[row][branch];
                        change = changeFraction * change;
                        this.m_delayTime[row][branch] = this.m_delayTime[row][branch] + change;
                        this.m_delayTime[row][branch] = Math.max(this.m_delayTime[row][branch], 0.0f);
                        continue;
                    }
                    ++numBad;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void getVelocityFromGrid(Grid3D grid, int branch) throws Exception {
        try {
            for (int row = 0; row < this.Table.row_count(); ++row) {
                this.m_velocity[row][branch] = grid.getNearestValue(this.X[row], this.Y[row]);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void updateVelocityGrid_SlopeValid(Grid3D grid, int branch) throws Exception {
        try {
            for (int row = 0; row < this.Table.row_count(); ++row) {
                if (!this.Alive[row] || !this.SlopeValid[row][branch]) continue;
                grid.interp_Add(this.X[row], this.Y[row], this.m_velocity[row][branch], this.SlopeSumW[row][branch]);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void updateVelocityGrid(Grid3D grid, int branch) throws Exception {
        try {
            double countSum = 0.0;
            double count = 1.0E-20;
            for (int row = 0; row < this.Table.row_count(); ++row) {
                if (!this.Alive[row]) continue;
                count += 1.0;
                countSum += (double)this.Count[row][branch];
            }
            double avgCount = countSum / count;
            double minValidCount = avgCount / 10.0;
            minValidCount = Math.max(4.0, minValidCount);
            for (int row = 0; row < this.Table.row_count(); ++row) {
                if (!this.Alive[row] || !((double)this.Count[row][branch] > minValidCount)) continue;
                grid.interp_Add(this.X[row], this.Y[row], this.m_velocity[row][branch], this.WeightSum[row][branch]);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeVelocityUsingArrays(int iteration) throws Exception {
        try {
            float changeFraction = 0.7f;
            int numZero = 0;
            for (int row = 0; row < this.Table.row_count(); ++row) {
                for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                    float count = this.Count[row][branch];
                    if (count < 0.5f) {
                        ++numZero;
                        continue;
                    }
                    float desiredVelocity = this.UpdateSum[row][branch] / this.WeightSum[row][branch];
                    float change = desiredVelocity - this.m_velocity[row][branch];
                    change = changeFraction * change;
                    this.m_velocity[row][branch] = this.m_velocity[row][branch] + change;
                    this.m_velocity[row][branch] = Math.max(this.m_velocity[row][branch], 200.0f);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeVelocityUsingLinearFit() {
        try {
            boolean junk = false;
            for (int row = 0; row < this.Table.row_count(); ++row) {
                for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                    this.SlopeValid[row][branch] = false;
                    if (!this.Alive[row] || !(this.Count[row][branch] > 5.5f)) continue;
                    if (row == 25) {
                        junk = true;
                    }
                    double sumW = this.SlopeSumW[row][branch];
                    double sumX = this.SlopeSumX[row][branch];
                    double sumXX = this.SlopeSumXX[row][branch];
                    double sumXV = this.SlopeSumXV[row][branch];
                    double sumV = this.SlopeSumV[row][branch];
                    double denom = sumW * sumXX - sumX * sumX;
                    if (!(Math.abs(denom) > 1.0E-5)) continue;
                    double b = (sumV * sumXX - sumX * sumXV) / denom;
                    double a = (sumW * sumXV - sumX * sumV) / denom;
                    float slope = (float)a;
                    float currentVel = this.m_velocity[row][branch];
                    float newVel = currentVel / (1.0f - slope * currentVel);
                    float desiredChange = newVel - currentVel;
                    float allowedChange = 0.75f * desiredChange;
                    this.m_velocity[row][branch] = currentVel + allowedChange;
                    this.SlopeValid[row][branch] = true;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearDelayTimeAnisotropy() throws Exception {
        try {
            for (int row = 0; row < this.Table.row_count(); ++row) {
                for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                    this.m_delayTimeAnisAz[row][branch] = 0.0f;
                    this.m_delayTimeAnisMag[row][branch] = 0.0f;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void clearSummationArrays(boolean clearDelayTimes) throws Exception {
        try {
            for (int row = 0; row < this.Table.row_count(); ++row) {
                for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                    this.Count[row][branch] = 1.0E-20f;
                    this.UpdateSum[row][branch] = 0.0f;
                    this.WeightSum[row][branch] = 1.0E-40f;
                    this.ErrorSum[row][branch] = 0.0f;
                    this.SlopeSumW[row][branch] = 1.0E-20f;
                    this.SlopeSumX[row][branch] = 0.0f;
                    this.SlopeSumV[row][branch] = 0.0f;
                    this.SlopeSumXX[row][branch] = 0.0f;
                    this.SlopeSumXV[row][branch] = 0.0f;
                    this.SlopeValid[row][branch] = false;
                    if (!clearDelayTimes) continue;
                    this.m_delayTime[row][branch] = 1.0E-10f;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void clearWaterBottomCorrections() {
        try {
            for (int branch = 0; branch <= this.MaxBranch; ++branch) {
                for (int row = 0; row < this.Table.row_count(); ++row) {
                    this.WaterBottomCorrectionTime[row][branch] = 0.0f;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeWaterBottomCorrections(WaterBottomCorrection.Method method) {
        try {
            this.clearWaterBottomCorrections();
            WaterBottomCorrection computer = WaterBottomCorrection.singleton();
            double waterVel = RefractionStaticsProject.singleton().getWaterVelocity();
            for (int row = 0; row < this.Table.row_count(); ++row) {
                double waterDepth = this.WaterDepth[row];
                double pointDepth = this.Depth[row];
                double refVel = this.m_velocity[row][1];
                this.WaterBottomCorrectionTime[row][1] = computer.compute(method, waterDepth, pointDepth, waterVel, refVel);
                for (int branch = 2; branch <= this.MaxBranch; ++branch) {
                    this.WaterBottomCorrectionTime[row][branch] = this.WaterBottomCorrectionTime[row][1];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeWaterBottomCorrections(WaterBottomCorrection.Method method, double waterVel) {
        try {
            this.clearWaterBottomCorrections();
            WaterBottomCorrection computer = WaterBottomCorrection.singleton();
            for (int row = 0; row < this.Table.row_count(); ++row) {
                double waterDepth = this.WaterDepth[row];
                double pointDepth = this.Depth[row];
                double refVel = this.m_velocity[row][1];
                this.WaterBottomCorrectionTime[row][1] = computer.compute(method, waterDepth, pointDepth, waterVel, refVel);
                for (int branch = 2; branch <= this.MaxBranch; ++branch) {
                    this.WaterBottomCorrectionTime[row][branch] = this.WaterBottomCorrectionTime[row][1];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearUpholeCorrections() {
        try {
            for (int branch = 0; branch <= this.MaxBranch; ++branch) {
                for (int row = 0; row < this.Table.row_count(); ++row) {
                    this.UpholeCorrectionTime[row][branch] = 0.0f;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeUpholeCorrections(UpholeCorrection.Method method) {
        try {
            this.clearUpholeCorrections();
            UpholeCorrection upholeComputer = UpholeCorrection.singleton();
            for (int row = 0; row < this.Table.row_count(); ++row) {
                upholeComputer.UpholeTime = this.Uphole[row];
                upholeComputer.PointDepth = this.Depth[row];
                upholeComputer.DelayTime[1] = this.m_delayTime[row][1];
                upholeComputer.Velocity[1] = this.m_velocity[row][1];
                this.UpholeCorrectionTime[row][1] = upholeComputer.compute(1, method);
                for (int branch = 2; branch <= this.MaxBranch; ++branch) {
                    this.UpholeCorrectionTime[row][branch] = this.UpholeCorrectionTime[row][1];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void getUpdatedColumns(Set<String> columns, boolean ComputingShearWaveDelayTimes) throws Exception {
        try {
            for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                String colNameDT = Pecos.getColNameDT(branch);
                String colNameDTAnisAz = Pecos.getColNameDtAnisAz(branch);
                String colNameDTAnisMag = Pecos.getColNameDtAnisMag(branch);
                String colNameVel = Pecos.getColNameVel(branch);
                String colNameErrorDT = Pecos.getColNameError(branch);
                String colNameCountDT = Pecos.getColNameCount(branch);
                columns.add(colNameDT);
                columns.add(colNameDTAnisAz);
                columns.add(colNameDTAnisMag);
                columns.add(colNameVel);
                columns.add(colNameErrorDT);
                columns.add(colNameCountDT);
                if (!ComputingShearWaveDelayTimes) continue;
                columns.add(Pecos.getConvWave_DT(branch));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void update_table_velocity() throws Exception {
        try {
            for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                for (int row = 0; row < this.Table.row_count(); ++row) {
                    this.Table.putDouble(row, this.IndexVel[branch], this.m_velocity[row][branch]);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void updateTables(boolean ComputingShearWaveDelayTimes) throws Exception {
        try {
            for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                int indexDT = -9999;
                if (ComputingShearWaveDelayTimes) {
                    indexDT = this.Table.column_append(Pecos.getConvWave_DT(branch), DataType.Double);
                }
                for (int row = 0; row < this.Table.row_count(); ++row) {
                    if (ComputingShearWaveDelayTimes) {
                        this.Table.putDouble(row, indexDT, this.m_delayTime[row][branch]);
                    }
                    if (ComputingShearWaveDelayTimes) continue;
                    if (this.Modified_DelayTimeAnisotropy) {
                        this.Table.putDouble(row, this.IndexDTAnisAz[branch], this.m_delayTimeAnisAz[row][branch]);
                        this.Table.putDouble(row, this.IndexDTAnisMag[branch], this.m_delayTimeAnisMag[row][branch]);
                    }
                    if (this.Modified_DelayTime) {
                        this.Table.putDouble(row, this.IndexDT[branch], this.m_delayTime[row][branch]);
                    }
                    if (this.Modified_Velocity) {
                        this.Table.putDouble(row, this.IndexVel[branch], this.m_velocity[row][branch]);
                    }
                    if (this.Modified_Count) {
                        this.Table.putDouble(row, this.IndexCount[branch], this.Count[row][branch]);
                    }
                    if (!this.Modified_Error) continue;
                    double error = 0.0;
                    if (this.Count[row][branch] > 0.5f) {
                        error = this.ErrorSum[row][branch] / this.Count[row][branch];
                    }
                    this.Table.putDouble(row, this.IndexError[branch], error);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void updateDatabase(boolean updateWeatheringVel, boolean ComputingShearWaveDelayTimes) throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            IDatabaseConnection db = project.geometryDatabase();
            if (updateWeatheringVel) {
                String colNameVel = Pecos.getColNameVel(0);
                db.addColumn(this.Table.name(), colNameVel, DataType.Double);
                db.writeColumnContentsToDatabase(this.Table, colNameVel);
            }
            for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                String colNameDT = Pecos.getColNameDT(branch);
                String colNameCWDT = Pecos.getConvWave_DT(branch);
                String colNameDTAnisAz = Pecos.getColNameDtAnisAz(branch);
                String colNameDTAnisMag = Pecos.getColNameDtAnisMag(branch);
                String colNameVel = Pecos.getColNameVel(branch);
                String colNameErrorDT = Pecos.getColNameError(branch);
                String colNameCountDT = Pecos.getColNameCount(branch);
                db.addColumn(this.Table.name(), colNameDT, DataType.Double);
                db.addColumn(this.Table.name(), colNameDTAnisAz, DataType.Double);
                db.addColumn(this.Table.name(), colNameDTAnisMag, DataType.Double);
                db.addColumn(this.Table.name(), colNameVel, DataType.Double);
                db.addColumn(this.Table.name(), colNameErrorDT, DataType.Double);
                db.addColumn(this.Table.name(), colNameCountDT, DataType.Int);
                if (ComputingShearWaveDelayTimes) {
                    db.addColumn(this.Table.name(), colNameCWDT, DataType.Double);
                }
                if (this.Modified_DelayTimeAnisotropy && !ComputingShearWaveDelayTimes) {
                    db.writeColumnContentsToDatabase(this.Table, colNameDTAnisAz);
                    db.writeColumnContentsToDatabase(this.Table, colNameDTAnisMag);
                }
                if (ComputingShearWaveDelayTimes) {
                    db.writeColumnContentsToDatabase(this.Table, colNameCWDT);
                }
                if (this.Modified_DelayTime) {
                    db.writeColumnContentsToDatabase(this.Table, colNameDT);
                }
                if (this.Modified_Velocity && !ComputingShearWaveDelayTimes) {
                    db.writeColumnContentsToDatabase(this.Table, colNameVel);
                }
                if (this.Modified_Count && !ComputingShearWaveDelayTimes) {
                    db.writeColumnContentsToDatabase(this.Table, colNameCountDT);
                }
                if (!this.Modified_Error || ComputingShearWaveDelayTimes) continue;
                db.writeColumnContentsToDatabase(this.Table, colNameErrorDT);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public float[][] getVelocity() {
        return this.m_velocity;
    }

    public float[][] getDelayTime() {
        return this.m_delayTime;
    }

    public float[][] getDelayTimeAnisAz() {
        return this.m_delayTimeAnisAz;
    }

    public float[][] getDelayTimeAnisMag() {
        return this.m_delayTimeAnisMag;
    }
}

