/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Action.Action_Base;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class Action_Sequence {
    protected ArrayList<Action_Base> m_list = new ArrayList();
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();

    public void clear() {
        try {
            this.m_list.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addAction(Action_Base action) {
        try {
            if (action != null) {
                this.m_list.add(action);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int size() {
        return this.m_list.size();
    }

    public Action_Base action(int index) {
        try {
            return this.m_list.get(index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void addListener(Listener listener) {
        try {
            if (listener == null) {
                return;
            }
            this.m_listeners.add(new WeakReference<Listener>(listener));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearListeners() {
        try {
            this.m_listeners.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void sendSequenceFinished() {
        try {
            for (WeakReference<Listener> l : this.m_listeners) {
                Listener listener = (Listener)l.get();
                if (listener == null) continue;
                listener.handleActionSequenceFinished(this);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean requiresRefractionStaticsProject() {
        try {
            for (Action_Base action : this.m_list) {
                if (!action.RequiresRefractionStaticsProject) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static interface Listener {
        public void handleActionSequenceFinished(Action_Sequence var1);
    }
}

