/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import java.util.ArrayList;

public class Action_Messenger
implements IProgressMonitor {
    public static final int Index_Description = 0;
    public static final int Index_ActionRunTime = 1;
    public static final int Index_Status1 = 2;
    public static final int Index_Status2 = 3;
    public static final int Index_Status3 = 4;
    protected long m_runStartTime = System.currentTimeMillis();
    protected long m_taskStartTime = System.currentTimeMillis();
    protected boolean m_tableModified = false;
    protected ArrayList<MessageEntry> m_statusMessages = new ArrayList();
    protected double m_percent = 0.0;
    protected boolean m_percentModified = false;
    protected double m_subtaskpercent;
    protected boolean m_subtaskpercentModified = false;

    public Action_Messenger() {
        try {
            for (int n = 0; n < 8; ++n) {
                this.m_statusMessages.add(new MessageEntry());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized long runStartTime() {
        return this.m_runStartTime;
    }

    public synchronized String getTimeMem() {
        try {
            long totalTime = System.currentTimeMillis() - this.runStartTime();
            String timeMessage = Tools_Strings.runTimeMessage((int)totalTime / 1000);
            return String.format("Run time: %s     Free memory (MB) = %d", timeMessage, (int)(Runtime.getRuntime().freeMemory() / 1000000L));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ex.getMessage();
        }
    }

    public synchronized long taskStartTime() {
        return this.m_taskStartTime;
    }

    public synchronized void resetTaskStartTime() {
        this.m_taskStartTime = System.currentTimeMillis();
    }

    public synchronized String getTimeLeft() {
        try {
            double v = this.m_percent;
            if (v < 0.1) {
                return " ";
            }
            double taskTime = System.currentTimeMillis() - this.taskStartTime();
            double timeLeft = taskTime * ((100.0 - v) / v);
            if (taskTime < 5000.0) {
                return " ";
            }
            String timeMessage = Tools_Strings.runTimeMessage((int)timeLeft / 1000);
            return timeMessage + " for this task";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ex.getMessage();
        }
    }

    public synchronized boolean tableModified() {
        return this.m_tableModified;
    }

    public synchronized void setTableModified(boolean bMod) {
        this.m_tableModified = bMod;
    }

    public synchronized void setMessage(int index, String message) {
        try {
            if (message == null) {
                message = "";
            }
            this.m_statusMessages.get((int)index).Modified = true;
            this.m_statusMessages.get((int)index).Message = message;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized boolean messageModified(int index) {
        try {
            return this.m_statusMessages.get((int)index).Modified;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public synchronized String message(int index) {
        try {
            this.m_statusMessages.get((int)index).Modified = false;
            return this.m_statusMessages.get((int)index).Message;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    public synchronized boolean percentModified() {
        return this.m_percentModified;
    }

    public synchronized double percentDone() {
        this.m_percentModified = false;
        return this.m_percent;
    }

    public synchronized boolean subtaskpercentModified() {
        return this.m_subtaskpercentModified;
    }

    public synchronized double subtaskpercentDone() {
        this.m_subtaskpercentModified = false;
        return this.m_subtaskpercent;
    }

    @Override
    public synchronized void setPercentDone(double percent) {
        this.m_percent = Math.max(percent, 0.0);
        this.m_percent = Math.min(percent, 100.0);
        this.m_percentModified = true;
    }

    @Override
    public synchronized void setSubTaskPercentDone(double percent) {
        this.m_subtaskpercent = Math.max(percent, 0.0);
        this.m_subtaskpercent = Math.min(percent, 100.0);
        this.m_subtaskpercentModified = true;
    }

    @Override
    public synchronized void setDescription(String description) {
        try {
            this.setMessage(2, description);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public synchronized void setMessage_Level1(String message) {
        try {
            this.setMessage(2, message);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public synchronized void setMessage_Level2(String message) {
        try {
            this.setMessage(3, message);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public synchronized void setMessage_Level3(String message) {
        try {
            this.setMessage(4, message);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public synchronized void updateTimeAndMemory() {
    }

    protected class MessageEntry {
        public boolean Modified = true;
        public String Message = "";

        protected MessageEntry() {
        }
    }
}

