/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.wavelet;

import org.javaseis.fft.IFFT;
import org.javaseis.fft.SeisFft;
import org.javaseis.wavelet.Window1D;

public class DualDomainWT {
    private int nx;
    private int nk;
    private int nxp;
    private float dx;
    private float dk;
    private int nxwin;
    private int nkwin;
    private int lxwin;
    private int lkwin;
    private int nxt;
    private int nkt;
    private SeisFft wxfft;
    private SeisFft wkfft;
    private SeisFft xkfft;
    private Window1D xwin;
    private Window1D kwin;
    private int maxlen;

    public DualDomainWT(int nxIn, float dxIn, int windowLength, float windowOverlap) {
        this.nx = nxIn;
        this.dx = dxIn;
        this.lxwin = SeisFft.length(windowLength, 0.0f, IFFT.Type.COMPLEX);
    }

    public void initializeChucklet1D(int nxIn, float dxIn, int winLen) {
        this.nx = nxIn;
        this.dx = dxIn;
        this.lxwin = SeisFft.length(winLen, 0.0f, IFFT.Type.COMPLEX);
        if (this.lxwin != winLen) {
            throw new IllegalArgumentException("Input window length " + winLen + " is not a valid FFT length");
        }
        this.lkwin = winLen;
        int nwtest = this.nx / this.lxwin;
        this.nkwin = this.nxwin = SeisFft.length(nwtest, 0.0f, IFFT.Type.COMPLEX);
        this.nk = this.nkwin * this.lkwin;
    }
}

