/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import org.javaseis.io.ExtentPolicyRandom;
import org.javaseis.io.Seisio;
import org.javaseis.io.VirtualFolders;
import org.javaseis.tests.SynthDataset4D;
import org.javaseis.tests.TestUtil;
import org.javaseis.util.SeisException;

public class WriteReadTests {
    private static final int LIMIT = 4;
    private static final int INCREMENT = 2;
    private static final String DS_BASE_NAME = "ReadWriteTest.js";
    private static final int NUM_TRACES = 50;
    private static final int NUM_FRAMES = 11;
    private static final int NUM_VOLUMES = 21;

    public static void main(String[] args) throws Exception {
        WriteReadTests t = new WriteReadTests();
        t.writeTest(50, 11, 21);
        t.readTest(50, 11, 21);
        System.out.println(" *** org.javaseis.tests.WriteReadTests SUCCESS");
    }

    private void profileW(int t, int f, int v) throws SeisException {
        System.out.println("profileTest, numVolumes: + " + v + " numFrames: " + f + " numTraces: " + t);
        int i = 12;
        String name = i + "-V-" + DS_BASE_NAME;
        String path = TestUtil.getDatasetPath(name);
        VirtualFolders vFolders = TestUtil.getVirtualFolders(path);
        SynthDataset4D ds = new SynthDataset4D(path, t, f, v, vFolders, i, new ExtentPolicyRandom());
        Seisio seisio = ds.create();
        seisio.trackIoRate(true);
        long start = System.currentTimeMillis();
        ds.writeData(0, f, 0, v);
        System.out.println("writeData(" + i + ") " + (System.currentTimeMillis() - start) + " " + this.rates(seisio));
        seisio.close();
        seisio = null;
    }

    private void profileR() throws SeisException {
        int i = 12;
        String name = i + "-V-" + DS_BASE_NAME;
        String path = TestUtil.getDatasetPath(name);
        VirtualFolders vFolders = TestUtil.getVirtualFolders(path);
        SynthDataset4D ds = new SynthDataset4D(path, vFolders);
        Seisio seisio = ds.open("r");
        seisio.trackIoRate(true);
        long start = System.currentTimeMillis();
        ds.readAllData();
        System.out.println("readData " + (System.currentTimeMillis() - start) + " " + this.rates(seisio));
        seisio.close();
        seisio = null;
    }

    private void readTest(int t, int f, int v) throws SeisException {
        System.out.println("readTest, numVolumes: + " + v + " numFrames: " + f + " numTraces: " + t);
        String path = TestUtil.getDatasetPath(DS_BASE_NAME);
        SynthDataset4D ds = new SynthDataset4D(path);
        Seisio seisio = ds.open("r");
        seisio.trackIoRate(true);
        long start = System.currentTimeMillis();
        ds.readData(0, f, 0, v);
        System.out.println("readData: " + (System.currentTimeMillis() - start) + " " + this.rates(seisio));
        seisio.close();
        seisio = null;
        for (int i = 1; i < 4; i += 2) {
            String name = i + "-V-" + DS_BASE_NAME;
            path = TestUtil.getDatasetPath(name);
            VirtualFolders vFolders = TestUtil.getVirtualFolders(path);
            ds = new SynthDataset4D(path, vFolders);
            seisio = ds.open("r");
            seisio.trackIoRate(true);
            start = System.currentTimeMillis();
            ds.readData(0, f, 0, v);
            System.out.println("readData(" + i + ") " + (System.currentTimeMillis() - start) + " " + this.rates(seisio));
            seisio.close();
            seisio = null;
        }
        path = TestUtil.getDatasetPath("2-ReadWriteTest.js");
        ds = new SynthDataset4D(path);
        seisio = ds.open("r");
        seisio.trackIoRate(true);
        start = System.currentTimeMillis();
        ds.readData(0, f, 0, v);
        System.out.println("readData: " + (System.currentTimeMillis() - start) + " " + this.rates(seisio));
        seisio.close();
        seisio = null;
    }

    private void writeTest(int t, int f, int v) throws SeisException {
        System.out.println("writeTest, numVolumes: + " + v + " numFrames: " + f + " numTraces: " + t);
        String path = TestUtil.getDatasetPath(DS_BASE_NAME);
        SynthDataset4D ds = new SynthDataset4D(path, t, f, v);
        Seisio seisio = ds.create();
        seisio.trackIoRate(true);
        long start = System.currentTimeMillis();
        ds.writeData(0, f, 0, v);
        System.out.println("writeData: " + (System.currentTimeMillis() - start) + " " + this.rates(seisio));
        seisio.close();
        seisio = null;
        for (int i = 1; i < 4; i += 2) {
            String name = i + "-V-" + DS_BASE_NAME;
            path = TestUtil.getDatasetPath(name);
            VirtualFolders vFolders = TestUtil.getVirtualFolders(path);
            ds = new SynthDataset4D(path, t, f, v, vFolders, i, new ExtentPolicyRandom());
            seisio = ds.create();
            seisio.trackIoRate(true);
            start = System.currentTimeMillis();
            ds.writeData(0, f, 0, v);
            System.out.println("writeData(" + i + ") " + (System.currentTimeMillis() - start) + " " + this.rates(seisio));
            seisio.close();
            seisio = null;
        }
        path = TestUtil.getDatasetPath("2-ReadWriteTest.js");
        ds = new SynthDataset4D(path, t, f, v);
        seisio = ds.create();
        seisio.trackIoRate(true);
        start = System.currentTimeMillis();
        ds.writeData(0, f, 0, v);
        System.out.println("writeData: " + (System.currentTimeMillis() - start) + " " + this.rates(seisio));
        seisio.close();
        seisio = null;
    }

    private String rates(Seisio seisio) {
        StringBuffer str = new StringBuffer();
        str.append(" totalBytes: " + seisio.getTotalIoBytes());
        str.append(" totalIoRate: " + seisio.getTotalIoRate());
        str.append(" totalIoTime: " + seisio.getTotalIoTime());
        str.append(" traceIO: " + seisio.getTraceIoRate());
        str.append(" headerIO: " + seisio.getHeaderIoRate());
        return str.toString();
    }
}

