/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.properties;

import java.io.Serializable;
import java.util.HashMap;

public class Units
implements Serializable {
    static final long serialVersionUID = 3693370955939885509L;
    private static final HashMap c_nameMap = new HashMap();
    public static final Units FEET;
    public static final Units FT;
    public static final Units METERS;
    public static final Units M;
    public static final Units MILLISECONDS;
    public static final Units MS;
    public static final Units MSEC;
    public static final Units SECONDS;
    public static final Units MICROSEC;
    public static final Units HERTZ;
    public static final Units HZ;
    public static final Units DEGREES;
    public static final Units NULL;
    public static final Units UNKNOWN;
    private String _name = null;
    private String _description;

    public static Units get(String name) {
        if (name == null) {
            return null;
        }
        return (Units)c_nameMap.get(name);
    }

    public Units(String name, String description) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description is null");
        }
        this._name = name.toLowerCase();
        this._description = description;
        c_nameMap.put(this._name, this);
    }

    public Units(String name) {
        this._name = name.toLowerCase();
        this._description = name;
        c_nameMap.put(this._name, this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Units other = (Units)obj;
        return this._name.equals(other._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    static {
        FT = FEET = new Units("feet", "Units of feet");
        M = METERS = new Units("meters", "Units of meters");
        MS = MILLISECONDS = new Units("milliseconds", "Units of milliseconds");
        MSEC = MILLISECONDS;
        SECONDS = new Units("seconds", "Units of seconds");
        MICROSEC = new Units("microseconds", "Units of microseconds");
        HZ = HERTZ = new Units("hertz", "Units of Hertz");
        DEGREES = new Units("degrees", "Units of degres");
        NULL = new Units("null", "Unitless");
        UNKNOWN = new Units("unknown", "Units unknown");
    }
}

