/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.properties;

import java.io.Serializable;
import java.util.HashMap;

public class AxisLabel
implements Serializable {
    private static final HashMap c_nameMap = new HashMap();
    public static final AxisLabel UNDEFINED = new AxisLabel("UNDEFINED", "Undefined");
    public static final AxisLabel TIME = new AxisLabel("TIME", "Vertical time");
    public static final AxisLabel DEPTH = new AxisLabel("DEPTH", "Vertical depth");
    public static final AxisLabel OFFSET = new AxisLabel("OFFSET", "Source-receiver offset");
    public static final AxisLabel OFFSET_BIN = new AxisLabel("OFFSET_BIN", "Offset bin #");
    public static final AxisLabel CROSSLINE = new AxisLabel("CROSSLINE", "Crossline #");
    public static final AxisLabel INLINE = new AxisLabel("INLINE", "Inline #");
    public static final AxisLabel SOURCE = new AxisLabel("SOURCE", "Source #");
    public static final AxisLabel CMP = new AxisLabel("CMP", "Common midpoint #");
    public static final AxisLabel RECEIVER = new AxisLabel("RECEIVER", "Receiver #");
    public static final AxisLabel RECEIVER_LINE = new AxisLabel("RECEIVER_LINE", "Receiver line #");
    public static final AxisLabel CHANNEL = new AxisLabel("CHANNEL", "Receiver channel");
    public static final AxisLabel SAIL_LINE = new AxisLabel("SAIL_LINE", "Sail line");
    public static final AxisLabel VOLUME = new AxisLabel("VOLUME", "Volume #");
    private String _name;
    private String _description;

    public static AxisLabel get(String name) {
        String axisName = AxisLabel.getJavaSeisNameTranslation(name);
        return (AxisLabel)c_nameMap.get(axisName);
    }

    public static String getJavaSeisNameTranslation(String promaxName) {
        if (promaxName == null) {
            return null;
        }
        if ((promaxName = promaxName.trim().toUpperCase()).equals("ILINE")) {
            return "INLINE";
        }
        if (promaxName.equals("X-LINE") || promaxName.equals("XLINE")) {
            return "CROSSLINE";
        }
        if (promaxName.equals("OFB_NO")) {
            return "OFFSET_BIN";
        }
        if (promaxName.equals("XLINE_NO")) {
            return "CROSSLINE";
        }
        if (promaxName.equals("ILINE_NO")) {
            return "INLINE";
        }
        if (promaxName.equals("S_LINE")) {
            return "SAIL_LINE";
        }
        if (promaxName.equals("V_TIME")) {
            return "TIME";
        }
        if (promaxName.equals("TIME_IND")) {
            return "TIME";
        }
        if (promaxName.equals("V_DEPTH")) {
            return "DEPTH";
        }
        if (promaxName.equals("DPTH_IND")) {
            return "DEPTH";
        }
        if (promaxName.equals("REC_SLOC")) {
            return "RECEIVER";
        }
        if (promaxName.equals("CHAN")) {
            return "CHANNEL";
        }
        if (promaxName.equals("R_LINE")) {
            return "RECEIVER_LINE";
        }
        if (promaxName.equals("CDP")) {
            return "CMP";
        }
        return promaxName;
    }

    public static String getPromaxNameTranslation(String javaseisName) {
        if (javaseisName == null) {
            return null;
        }
        if ((javaseisName = javaseisName.trim().toUpperCase()).equals("OFFSET_BIN")) {
            return "OFB_NO";
        }
        if (javaseisName.equals("CROSSLINE")) {
            return "XLINE_NO";
        }
        if (javaseisName.equals("INLINE")) {
            return "ILINE_NO";
        }
        if (javaseisName.equals("SAIL_LINE")) {
            return "S_LINE";
        }
        if (javaseisName.equals("TIME")) {
            return "V_TIME";
        }
        if (javaseisName.equals("TIME")) {
            return "TIME_IND";
        }
        if (javaseisName.equals("DEPTH")) {
            return "V_DEPTH";
        }
        if (javaseisName.equals("DEPTH")) {
            return "DPTH_IND";
        }
        if (javaseisName.equals("RECEIVER")) {
            return "REC_SLOC";
        }
        if (javaseisName.equals("CHANNEL")) {
            return "CHAN";
        }
        if (javaseisName.equals("RECEIVER_LINE")) {
            return "R_LINE";
        }
        if (javaseisName.equals("CMP")) {
            return "CDP";
        }
        return javaseisName;
    }

    public static AxisLabel[] getDefault(int ndim) {
        AxisLabel[] axes = new AxisLabel[ndim];
        axes[0] = new AxisLabel("Sample", "Sample Index");
        if (ndim > 1) {
            axes[1] = new AxisLabel("Trace", "Trace Index");
        }
        if (ndim > 2) {
            axes[2] = new AxisLabel("Frame", "Frame Index");
        }
        if (ndim > 3) {
            axes[3] = new AxisLabel("Volume", "Volume Index");
        }
        if (ndim > 4) {
            axes[4] = new AxisLabel("Hypercube", "Hypercube Index");
        }
        return axes;
    }

    public AxisLabel(String name, String description) {
        if (name == null || description == null) {
            throw new IllegalArgumentException("Null input args are not allowed");
        }
        this._name = name.trim().toUpperCase();
        this._description = description;
        c_nameMap.put(this._name, this);
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AxisLabel other = (AxisLabel)obj;
        return this._name.equals(other._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return this._name;
    }
}

