/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.Seisio;
import org.javaseis.io.SortCompare;
import org.javaseis.io.SortIOParms;
import org.javaseis.io.SortMap;
import org.javaseis.io.SortMapIO;
import org.javaseis.io.SortRead;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.properties.AxisDefinition;
import org.javaseis.properties.DataFormat;
import org.javaseis.properties.TraceProperties;
import org.javaseis.util.ArrayUtil;
import org.javaseis.util.Pacifier;
import org.javaseis.util.SeisException;

public class SortCreate {
    private static final Logger LOG = Logger.getLogger(SortCreate.class.getName());
    private String _sortName;
    private Seisio _sio;
    private String _key2;
    private String _key3;
    private String _key4;
    private Decomposition _dc;
    private IParallelContext _pc;
    private Pacifier _pacify;
    private SortMap[] _ilist;
    private SortMap[] _olist;
    private int _localTraces;
    private int _localVolumes;
    private int _volumesPerTask;
    private String _sort3_secondary;
    private String _sort3_tertiary;
    private long _maxTracesPerFrame = -1L;
    private static final boolean debug_local_traces = false;
    private int _minLogVol;
    private int _maxLogVol;
    private int _minLogFrm;
    private int _maxLogFrm;
    private int _minLogTrc;
    private int _maxLogTrc;
    private int _tracesPerFrame;
    private int _volumes;
    private int _framesPerVolume;
    private long _tracesInSort;
    private SortMapIO _sortmapIO;
    private long[] _traceList;

    public SortCreate(Seisio sioFile, String name, String sort3i, String sort4i, String framework2i, Pacifier paci, IParallelContext pci) throws SeisException {
        this(sioFile, name, sort3i, sort4i, framework2i, paci, pci, "", "");
    }

    public SortCreate(Seisio sioFile, String name, String sort3i, String sort4i, String sort2i, Pacifier paci, IParallelContext pci, String sort3_secondary, String sort3_tertiary) throws SeisException {
        this(sioFile, name, sort3i, sort4i, sort2i, paci, pci, sort3_secondary, sort3_tertiary, -1L);
    }

    public SortCreate(Seisio sioFile, String name, String sort3i, String sort4i, String sort2i, Pacifier paci, IParallelContext pci, String sort3_secondary, String sort3_tertiary, long maxAllowedTPF) throws SeisException {
        pci.masterPrint(" Add Sort Order " + name + " for JavaSeis dataset " + sioFile.getBasePath());
        this._maxTracesPerFrame = maxAllowedTPF;
        this._minLogVol = Integer.MAX_VALUE;
        this._maxLogVol = Integer.MIN_VALUE;
        this._minLogFrm = Integer.MAX_VALUE;
        this._maxLogFrm = Integer.MIN_VALUE;
        this._minLogTrc = Integer.MAX_VALUE;
        this._maxLogTrc = Integer.MIN_VALUE;
        if (!sioFile._usesHeaderProperties) {
            throw new SeisException("No headers exist for " + sioFile.getBasePath());
        }
        DataFormat traceFormat = sioFile.getDataDefinition().getTraceFormat();
        if (traceFormat == DataFormat.SEISPEG) {
            throw new SeisException("A dataset compressed using SeisPEG compression cannot be sorted\nInline Merge sort can be used to sort a SeisPEG compressed dataset in parallel");
        }
        this._pc = pci;
        if (this._pc.rank() == 0) {
            if (SortRead.exists(sioFile, name)) {
                LOG.info("SortCreate Warning: Sort order " + name + " already exists");
            }
            if (!sioFile.getTraceProperties().exists(sort3i)) {
                throw new SeisException("Axis 3 property " + sort3i + " does not exist");
            }
            if (!sioFile.getTraceProperties().exists(sort4i)) {
                throw new SeisException("Axis 4 property " + sort4i + " does not exist");
            }
        }
        this._pc.barrier();
        this._sortName = name;
        this._key2 = sort2i;
        this._key3 = sort3i;
        this._key4 = sort4i;
        this._sort3_secondary = sort3_secondary;
        this._sort3_tertiary = sort3_tertiary;
        this._sio = sioFile;
        long maxPossibleFrames = this.maxPossibleFrames(this._sio);
        long maxPossibleTraces = this.maxPossibleTraces(this._sio);
        this._dc = new Decomposition(Decomposition.BLOCK, maxPossibleFrames, this._pc);
        this._pc.masterPrint(this.frameworkInfo(this._sio));
        this._pc.masterPrint("Dataset dimensions = " + this._sio.getGridDefinition().getNumDimensions());
        this._pc.masterPrint("Maximum possible frames in dataset = " + maxPossibleFrames);
        this._pc.masterPrint("Maximum possible traces in dataset = " + maxPossibleTraces);
        this._pc.masterPrint("---");
        this._pc.masterPrint("Using block by volume decomposition");
        for (int i = 0; i < this._pc.size(); ++i) {
            this._pc.masterPrint("Frames per task[" + i + "] " + Decomposition.liveElements(maxPossibleFrames, this._pc.size(), i));
        }
        this._pacify = paci;
        this.doSort();
    }

    private void doSort() throws SeisException {
        long ntrcl = this._dc.longLiveElements() * this._sio.getGridDefinition().getAxisLength(1);
        this._pc.masterPrint("Maximum possible traces per task = " + ntrcl);
        if (ntrcl > 0x8000000L) {
            throw new SeisException("Traces per task exceeds 134217728");
        }
        int ntrc_est = (int)ntrcl;
        this._ilist = new SortMap[ntrc_est];
        if (this._pacify != null) {
            this._pacify.init(this._dc.longLiveElements() * 2L);
        }
        this._pc.masterPrint("SortCreate: Scan Trace Properties for sort list ... ");
        long start_scan = System.currentTimeMillis();
        this.scan(ntrcl);
        long stop_scan = System.currentTimeMillis();
        this._pc.masterPrint("SortCreate: Trace Property scan completed in " + (stop_scan - start_scan) / 1000L + " seconds");
        long start_local_sort = System.currentTimeMillis();
        this.sortLocal(this._ilist);
        this.globalCount();
        long stop_local_sort = System.currentTimeMillis();
        this._pc.masterPrint("SortCreate: Local sort completed in " + (stop_local_sort - start_local_sort) / 1000L + " seconds");
        long start_parallel_sort = System.currentTimeMillis();
        this._pc.masterPrint("SortCreate: Begin parallel sort ... ");
        this.sortParallel();
        long stop_parallel_sort = System.currentTimeMillis();
        this._pc.masterPrint("SortCreate: Parallel sort completed in " + (stop_parallel_sort - start_parallel_sort) / 1000L + " seconds");
        this.sortLocal(this._olist);
        this.globalCount();
        this._ilist = null;
        System.gc();
        long start_write = System.currentTimeMillis();
        if (this._pc.isMaster()) {
            this.printStatistics();
            LOG.info("MaxTracesPerFrameAllowed = " + this._maxTracesPerFrame);
            if (this._maxTracesPerFrame > 1L && (long)this._tracesPerFrame > this._maxTracesPerFrame) {
                throw new SeisException("This sort results in '" + this._tracesPerFrame + "' traces per frame which exceeds the maximum allowable traces per frame of '" + this._maxTracesPerFrame + "'");
            }
        }
        this.createAndOpenSortMaps(this._pc);
        int localVolumes = this.numVolumesInTraceList();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Volumes on task: " + localVolumes);
        }
        int[] nvolPerTask = new int[this._pc.size()];
        nvolPerTask = this._pc.collectInt(localVolumes);
        this.sortWrite(nvolPerTask);
        long stop_write = System.currentTimeMillis();
        this._pc.masterPrint("SortCreate: Parallel write completed in " + (stop_write - start_write) / 1000L + " seconds");
        this._pc.masterPrint("Sort Order " + this._sortName + " added for JavaSeis dataset " + this._sio.getBasePath());
    }

    private void createAndOpenSortMaps(IParallelContext pc) throws SeisException {
        SortIOParms parms = new SortIOParms();
        parms.label2 = this._key2;
        parms.label3 = this._key3;
        parms.label4 = this._key4;
        parms.sort3_secondary = this._sort3_secondary;
        parms.sort3_tertiary = this._sort3_tertiary;
        parms.volumes = this._volumes;
        parms.framesPerVolume = this._framesPerVolume;
        parms.tracesPerFrame = this._tracesPerFrame;
        parms.tracesInSort = this._tracesInSort;
        parms.minLogVol = this._minLogVol;
        parms.maxLogVol = this._maxLogVol;
        parms.minLogFrm = this._minLogFrm;
        parms.maxLogFrm = this._maxLogFrm;
        parms.minLogTrc = this._minLogTrc;
        parms.maxLogTrc = this._maxLogTrc;
        if (pc.isMaster()) {
            try {
                SortIOParms.writeparms(this._sio.getBasePath(), this._sortName, parms);
            }
            catch (Exception e) {
                throw new SeisException("Unable to write parameter", e);
            }
        }
        try {
            this._sortmapIO = new SortMapIO(this._sio.getBasePath(), this._sortName, parms);
            this._sortmapIO.open("w");
            this._traceList = this._sortmapIO.getCurrentTraceList();
        }
        catch (IOException e) {
            throw new SeisException("Unable to open sortmaps", e);
        }
    }

    private void scan(long ntrcl) throws SeisException {
        long[] range = this._dc.longIndexRange();
        int ndim = this._sio.getGridDefinition().getNumDimensions();
        int nframeCount = (int)this._sio.getGridDefinition().getAxisLength(2);
        int nvolumeCount = -1;
        if (ndim > 4) {
            nvolumeCount = (int)this._sio.getGridDefinition().getAxisLength(3);
        }
        int[] position = new int[ndim];
        this._localTraces = 0;
        TraceProperties tp = this._sio.getTraceProperties();
        for (long il = range[0]; il <= range[1] && this._ilist.length > 0; il += range[2]) {
            this.frameIndexToPosition(il, nframeCount, nvolumeCount, position);
            int ntrc = this._sio.setPosition(position);
            long traceIndex = this._sio.getTraceIndex();
            if (ntrc > 0) {
                if (this._sio.readFrameHeaders() != ntrc) {
                    throw new SeisException("Trace count mis-match during header scan");
                }
                for (int i = 0; i < ntrc; ++i) {
                    tp.setTraceIndex(i);
                    this._ilist[this._localTraces] = new SortMap();
                    this._ilist[this._localTraces].lfrm = tp.getInt(this._key3);
                    this._ilist[this._localTraces].lvol = tp.getInt(this._key4);
                    int ltrc = tp.getInt(this._key2);
                    ++traceIndex;
                    this._ilist[this._localTraces].trc = this._ilist[this._localTraces].trc;
                    this._minLogVol = Math.min(this._minLogVol, this._ilist[this._localTraces].lvol);
                    this._maxLogVol = Math.max(this._maxLogVol, this._ilist[this._localTraces].lvol);
                    this._minLogFrm = Math.min(this._minLogFrm, this._ilist[this._localTraces].lfrm);
                    this._maxLogFrm = Math.max(this._maxLogFrm, this._ilist[this._localTraces].lfrm);
                    this._minLogTrc = Math.min(this._maxLogTrc, ltrc);
                    this._maxLogTrc = Math.max(this._maxLogTrc, ltrc);
                    ++this._localTraces;
                }
            }
            if (this._pacify == null) continue;
            this._pacify.update(il + 1L);
        }
    }

    private void printStatistics() {
        LOG.info("\n");
        LOG.info("Sort properties for sort order: " + this._sortName);
        LOG.info("VolumeAxisLabel   = " + this._key4);
        LOG.info("FrameAxisLabel    = " + this._key3);
        LOG.info("TraceAxisLabel    = " + this._key2);
        LOG.info("Number of volumes having at least 1 frame = " + this._volumes);
        LOG.info("Maximum number of live frames per volume  = " + this._framesPerVolume);
        LOG.info("Maximum number of live traces per frame   = " + this._tracesPerFrame);
        LOG.info("TotalTracesInSort = " + this._tracesInSort);
        LOG.info("Volume axis ranges");
        LOG.info(" Minimum " + this._key4 + " = " + this._minLogVol);
        LOG.info(" Maximum " + this._key4 + " = " + this._maxLogVol);
        LOG.info("Frame axis ranges");
        LOG.info(" Minimum " + this._key3 + " = " + this._minLogFrm);
        LOG.info(" Maximum " + this._key3 + " = " + this._maxLogFrm);
        LOG.info("Trace axis ranges");
        LOG.info(" Minimum " + this._key2 + " = " + this._minLogTrc);
        LOG.info(" Maximum " + this._key2 + " = " + this._maxLogTrc);
        LOG.info("\n");
    }

    private void sortLocal(SortMap[] list) {
        this._pc.serialPrint("Task " + this._pc.rank() + " Local Traces " + this._localTraces);
        this._tracesPerFrame = 0;
        this._framesPerVolume = 0;
        this._volumes = 0;
        if (this._localTraces == 0) {
            return;
        }
        Arrays.sort((Object[])list, 0, this._localTraces, new SortCompare());
        int logicalVolume = list[0].lvol;
        int logicalFrame = list[0].lfrm;
        int framesInCurrentVolume = 0;
        int tracesInCurrentFrame = 0;
        int maxObservedVolume = logicalVolume;
        int minObservedVolume = logicalVolume;
        int maxObservedFrame = logicalFrame;
        int minObservedFrame = logicalFrame;
        for (int i = 0; i < this._localTraces; ++i) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("For trace " + i + " volume= " + list[i].lvol + " frame= " + list[i].lfrm);
            }
            if (list[i].lvol < minObservedVolume) {
                minObservedVolume = list[i].lvol;
            }
            if (list[i].lvol > maxObservedVolume) {
                maxObservedVolume = list[i].lvol;
            }
            if (list[i].lfrm < minObservedFrame) {
                minObservedFrame = list[i].lfrm;
            }
            if (list[i].lfrm > maxObservedFrame) {
                maxObservedFrame = list[i].lfrm;
            }
            if (logicalVolume != list[i].lvol) {
                ++this._volumes;
                logicalVolume = list[i].lvol;
                if (++framesInCurrentVolume > this._framesPerVolume) {
                    this._framesPerVolume = framesInCurrentVolume;
                }
                framesInCurrentVolume = 0;
                logicalFrame = list[i].lfrm;
                if (tracesInCurrentFrame > this._tracesPerFrame) {
                    this._tracesPerFrame = tracesInCurrentFrame;
                }
                tracesInCurrentFrame = 0;
            } else if (logicalFrame != list[i].lfrm) {
                ++framesInCurrentVolume;
                logicalFrame = list[i].lfrm;
                if (tracesInCurrentFrame > this._tracesPerFrame) {
                    this._tracesPerFrame = tracesInCurrentFrame;
                }
                tracesInCurrentFrame = 0;
            }
            ++tracesInCurrentFrame;
        }
        ++this._volumes;
        if (++framesInCurrentVolume > this._framesPerVolume) {
            this._framesPerVolume = framesInCurrentVolume;
        }
        if (tracesInCurrentFrame > this._tracesPerFrame) {
            this._tracesPerFrame = tracesInCurrentFrame;
        }
    }

    private void globalCount() {
        long[] a = new long[2];
        long[] b = new long[2];
        a[0] = this._localTraces;
        this._pc.globalSumLong(a, 0, b, 0, 1);
        this._tracesInSort = b[0];
        int[] c = new int[5];
        int[] d = new int[5];
        c[0] = this._minLogFrm;
        c[1] = this._minLogVol;
        c[2] = this._minLogTrc;
        this._pc.globalMinInt(c, 0, d, 0, 3);
        this._minLogFrm = d[0];
        this._minLogVol = d[1];
        this._minLogTrc = d[2];
        c[0] = this._maxLogFrm;
        c[1] = this._maxLogVol;
        c[2] = this._maxLogTrc;
        c[3] = this._tracesPerFrame;
        c[4] = this._framesPerVolume;
        this._pc.globalMaxInt(c, 0, d, 0, 5);
        this._maxLogFrm = d[0];
        this._maxLogVol = d[1];
        this._maxLogTrc = d[2];
        this._tracesPerFrame = d[3];
        this._framesPerVolume = d[4];
        this._localVolumes = this._volumes;
        c[0] = this._volumes;
        this._pc.globalSumInt(c, 0, d, 0, 1);
        this._volumes = d[0];
    }

    private void sortParallel() {
        if (this._pc.size() < 2) {
            this._olist = this._ilist;
            return;
        }
        int size = this._pc.size();
        int[] na = new int[size];
        int[] nb = new int[size];
        int[] oa = new int[size];
        int[] ob = new int[size];
        int nvol = this._maxLogVol - this._minLogVol + 1;
        this._volumesPerTask = (int)Decomposition.elementsPerTask(nvol, size);
        Arrays.fill(na, 0);
        int ibin = 0;
        for (int i = 0; i < this._localTraces; ++i) {
            int n = ibin = (this._ilist[i].lvol - this._minLogVol) / this._volumesPerTask;
            na[n] = na[n] + 1;
        }
        int[] buf = new int[1];
        ArrayUtil.arraycopy(na, 0, nb, 0, size);
        this._pc.ttranInt(1, nb, 0, buf);
        int inputTraces = na[0];
        int outputTraces = nb[0];
        oa[0] = 0;
        ob[0] = 0;
        for (int i = 1; i < size; ++i) {
            oa[i] = inputTraces;
            ob[i] = outputTraces;
            inputTraces += na[i];
            outputTraces += nb[i];
        }
        this._olist = new SortMap[outputTraces];
        this._pc.ttranv(na, oa, this._ilist, nb, ob, this._olist);
        this._localTraces = outputTraces;
    }

    private void sortWrite(int[] nvolPerTask) throws SeisException {
        if (this._pacify != null) {
            this._pacify.init(this._localTraces * 2);
        }
        int ivolOffset = 0;
        for (int i = 1; i <= this._pc.rank(); ++i) {
            ivolOffset += nvolPerTask[i - 1];
        }
        LOG.info("Volumes per task " + nvolPerTask[this._pc.rank()] + " starting volume " + ivolOffset + " for task: " + this._pc.rank());
        int nfrm = 0;
        int ntrc = 0;
        int ifrm = 0;
        int nvol = 0;
        int lv = 0;
        int lf = 0;
        int ivol = ivolOffset;
        if (this._localTraces > 0) {
            lv = this._olist[0].lvol;
            lf = this._olist[0].lfrm;
        }
        for (int i = 0; i < this._localTraces; ++i) {
            if (lv != this._olist[i].lvol) {
                this._sortmapIO.writeTraceMap(ntrc, ivol, ifrm);
                this._sortmapIO.appendFrame(nfrm, lf, ntrc);
                this._sortmapIO.writeFrameMap(++nfrm, ivol);
                this._sortmapIO.appendVolume(nvol, lv, nfrm);
                ++nvol;
                ++ivol;
                lv = this._olist[i].lvol;
                lf = this._olist[i].lfrm;
                nfrm = 0;
                ntrc = 0;
                ifrm = 0;
            } else if (lf != this._olist[i].lfrm) {
                this._sortmapIO.writeTraceMap(ntrc, ivol, ifrm);
                ++ifrm;
                this._sortmapIO.appendFrame(nfrm, lf, ntrc);
                lf = this._olist[i].lfrm;
                ++nfrm;
                ntrc = 0;
            }
            if (this._pc.isMaster() && this._pacify != null) {
                this._pacify.update(this._localTraces + i + 1);
            }
            this._traceList[ntrc] = this._olist[i].trc;
            ++ntrc;
        }
        if (this._localTraces > 0) {
            this._sortmapIO.writeTraceMap(ntrc, ivol, ifrm);
            this._sortmapIO.appendFrame(nfrm, lf, ntrc);
            this._sortmapIO.writeFrameMap(++nfrm, ivol);
            this._sortmapIO.appendVolume(nvol, lv, nfrm);
            ++nvol;
        } else {
            nvol = 0;
            ivol = -1;
        }
        if (nvol > 0) {
            this._sortmapIO.writeVolumeMap(nvol, ivolOffset);
        }
    }

    private int numVolumesInTraceList() {
        long volumeMin = Long.MAX_VALUE;
        long volumeMax = Long.MIN_VALUE;
        long tmp = Long.MAX_VALUE;
        if (this._localTraces > 0) {
            tmp = this._olist[0].lvol;
        }
        if (this._localTraces == 0) {
            return 0;
        }
        int numVolumes = 1;
        for (int i = 0; i < this._localTraces; ++i) {
            if (tmp == (long)this._olist[i].lvol) continue;
            ++numVolumes;
            volumeMin = Math.min(volumeMin, (long)this._olist[i].lvol);
            volumeMax = Math.max(volumeMax, (long)this._olist[i].lvol);
            tmp = this._olist[i].lvol;
        }
        return numVolumes;
    }

    long maxPossibleFrames(Seisio sio) {
        int ndim = sio.getGridDefinition().getNumDimensions();
        long n = 1L;
        for (int i = 2; i < ndim; ++i) {
            n *= sio.getGridDefinition().getAxisLength(i);
        }
        return n;
    }

    long maxPossibleTraces(Seisio sio) {
        int ndim = sio.getGridDefinition().getNumDimensions();
        long n = 1L;
        for (int i = 1; i < ndim; ++i) {
            n *= sio.getGridDefinition().getAxisLength(i);
        }
        return n;
    }

    private String frameworkInfo(Seisio sio) {
        GridDefinition grid = sio.getGridDefinition();
        int ndim = grid.getNumDimensions();
        StringBuffer buf = new StringBuffer();
        buf.append("Dataset Framework\n");
        for (int i = 0; i < ndim; ++i) {
            AxisDefinition axis = grid.getAxis(i);
            long logicalOrigin = axis.getLogicalOrigin();
            long logicalCount = axis.getLength();
            long logicalInc = axis.getLogicalDelta();
            String name = axis.getLabel().getName();
            buf.append(name);
            buf.append(" " + logicalOrigin);
            buf.append(" - " + (logicalOrigin + (logicalCount - 1L) * logicalInc));
            buf.append(" (" + logicalInc + ")\n");
        }
        return buf.toString();
    }

    private void frameIndexToPosition(long iframe, int nFrameCount, int nVolumeCount, int[] position) {
        if (position.length > 4) {
            position[4] = (int)(iframe / (long)(nFrameCount * nVolumeCount));
            position[3] = (int)((iframe - (long)(position[4] * nVolumeCount * nFrameCount)) / (long)nFrameCount);
            position[2] = (int)(iframe - (long)(nFrameCount * position[3] + nFrameCount * nVolumeCount * position[4]));
        } else if (position.length > 3) {
            position[3] = (int)(iframe / (long)nFrameCount);
            position[2] = (int)(iframe - (long)(nFrameCount * position[3]));
        } else {
            position[2] = (int)(iframe - (long)nFrameCount * (iframe / (long)nFrameCount));
        }
    }

    public void close() {
        this._sortmapIO.close();
        this._olist = null;
    }
}

