/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javaseis.io.ExtentBaseNameFilter;
import org.javaseis.io.ExtentListEntry;
import org.javaseis.io.ExtentLock;
import org.javaseis.io.VirtualFolder;
import org.javaseis.io.VirtualFolders;
import org.javaseis.util.SeisException;

public class ExtentList {
    private static final Logger LOG = Logger.getLogger(ExtentList.class.getName());
    private ExtentListEntry[] _extents;
    private int _numExtents;
    private long _maxFilePosition;
    private String _extBaseName;
    private VirtualFolders _vFolders;
    private long _extentSize;
    private boolean _trackTime;
    private long _lockTime;
    private float _loadTime;
    private boolean _readOnly;
    public static final String[] EXCLUDE_EXTN = new String[]{".lok", ".xml"};
    private static final int WAIT = 250;
    private static final int RETRIES = Integer.parseInt(System.getProperty("org.javaseis.io.extentlist.retryCount", "50"));

    private ExtentList() {
    }

    public ExtentList(String extBaseName, int numExtents, long maxFilePosition, long extentSize, VirtualFolders vFolders, boolean mode) {
        if (extBaseName == null || extBaseName.length() == 0) {
            throw new IllegalArgumentException("Invalid baseName for the extents");
        }
        if (maxFilePosition == 0L) {
            throw new IllegalArgumentException("maxFilePosition must be greater than 0");
        }
        if (extentSize == 0L) {
            throw new IllegalArgumentException("extentSize must be greater than 0");
        }
        if (vFolders == null) {
            throw new IllegalArgumentException("Invalid virtual directories");
        }
        this._numExtents = numExtents;
        this._maxFilePosition = maxFilePosition;
        this._extBaseName = extBaseName;
        this._vFolders = vFolders;
        this._extentSize = extentSize;
        this._extents = new ExtentListEntry[numExtents];
        this._readOnly = mode;
    }

    public ExtentListEntry getExtent(long position) throws SeisException {
        if (position > this._maxFilePosition) {
            throw new IllegalArgumentException("Requested position(" + position + " exceeded the file size " + this._maxFilePosition);
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Requested position(" + position + " is invalid ");
        }
        int index = this.getExtentIndex(position);
        if (this._extents[index] == null) {
            String name = this._extBaseName + index;
            if (this._readOnly) {
                for (int i = 1; i <= RETRIES; ++i) {
                    try {
                        if (this.addExistingExtent(name, index)) {
                            return this._extents[index];
                        }
                        LOG.info("Dataset is opened read only.  Searching for exent that should exist '" + name + "'");
                        Thread.sleep(250 * i);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                throw new SeisException("Extent: " + index + " at position: " + position + " does not exist and dataset is opened as read only");
            }
            this.createExtent(index);
        }
        return this._extents[index];
    }

    private void createExtent(int index) throws SeisException {
        assert (index >= 0);
        assert (index < this._numExtents);
        int folderIndex = this._vFolders.getPolicy().getNextExtentFolder(index, this._numExtents, this._vFolders);
        if (folderIndex < 0 || folderIndex > this._vFolders.getFolders().length) {
            throw new SeisException("Unable to allocate extent");
        }
        String folder = this._vFolders.getFolders()[folderIndex].getPath();
        String name = this._extBaseName + index;
        String path = folder + File.separator + name;
        if (this.addExistingExtent(name, index)) {
            return;
        }
        String lockFolder = this._vFolders.getLockFolder();
        ExtentLock extentLock = new ExtentLock(lockFolder, name + EXCLUDE_EXTN[0]);
        if (extentLock.exists()) {
            for (int i = 1; i <= RETRIES; ++i) {
                try {
                    Thread.sleep(250 * i);
                    LOG.finer("Searching for exent '" + name + "'");
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.addExistingExtent(name, index)) continue;
                return;
            }
            throw new SeisException("Lock file exists but the extent was never found for segment '" + name + "'");
        }
        boolean bLock = extentLock.lock();
        if (!bLock) {
            for (int i = 1; i <= RETRIES; ++i) {
                try {
                    Thread.sleep(250 * i);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.addExistingExtent(name, index)) continue;
                return;
            }
            throw new SeisException("Lock file found after failed lock attempt, but the extent was never found for segment '" + name + "'");
        }
        if (bLock) {
            try {
                ExtentListEntry e;
                String hPath;
                File hFile;
                File extentF = new File(path);
                File parent = extentF.getParentFile();
                extentF.createNewFile();
                if (this._extBaseName.equalsIgnoreCase("TraceFile") && !(hFile = new File(hPath = path.replace("TraceFile", "TraceHeaders"))).exists()) {
                    hFile.createNewFile();
                }
                this._extents[index] = e = new ExtentListEntry(name, index, this._extentSize * (long)index, this._extentSize, path);
            }
            catch (IOException ex) {
                throw new SeisException("Could not create extent at " + path + " " + ex);
            }
        }
    }

    private boolean addExistingExtent(String name, int index) {
        assert (name != null && name.length() > 0);
        assert (index >= 0 && index < this._numExtents);
        String existingExtentPath = this.findExtent(name);
        if (existingExtentPath != null) {
            ExtentListEntry e;
            LOG.finer("Adding an existing extent to the list: " + name);
            this._extents[index] = e = new ExtentListEntry(name, index, this._extentSize * (long)index, this._extentSize, existingExtentPath);
            return true;
        }
        return false;
    }

    private int getExtentIndex(long position) {
        if (position > this._maxFilePosition) {
            throw new IllegalArgumentException("Position is not valid, " + position + " maxFilePosition = " + this._maxFilePosition);
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Position is not valid, " + position);
        }
        int index = (int)(position / this._extentSize);
        return index;
    }

    public String getExtentPath(int index) {
        if (index < 0 || index >= this._numExtents) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        return this._extents[index].getPath();
    }

    public String getExtentBase() {
        return this._extBaseName;
    }

    private String findExtent(String name) {
        File file;
        assert (name != null && name.length() > 0);
        long start = System.nanoTime();
        for (VirtualFolder folder : this._vFolders.getFolders()) {
            File file2 = new File(folder.getPath(), name);
            if (!file2.exists() && !file2.isFile() && file2.length() <= 0L) continue;
            if (this._trackTime) {
                this._loadTime = System.nanoTime() - start;
            }
            LOG.finer("Segment found via File.exists or File.isFile or File.length > 0" + file2.getAbsolutePath());
            return file2.getAbsolutePath();
        }
        ExtentBaseNameFilter filter = new ExtentBaseNameFilter(this._extBaseName, EXCLUDE_EXTN);
        for (VirtualFolder folder : this._vFolders.getFolders()) {
            file = new File(folder.getPath(), name);
            File folderDir = new File(folder.getPath());
            File[] listFiles = folderDir.listFiles();
            if (listFiles == null) continue;
            for (File listFile : listFiles) {
                int index;
                if (file.equals(listFile)) {
                    if (this._trackTime) {
                        this._loadTime = System.nanoTime() - start;
                    }
                    LOG.finer("Segment found via list files " + file.getAbsolutePath());
                    return file.getAbsolutePath();
                }
                String fname = listFile.getName();
                if (!filter.accept(folderDir, fname) || this._extents[index = this.getIndexFromName(fname)] != null) continue;
                LOG.finer("Adding segment " + fname);
                this.addExistingExtent(fname, index);
            }
        }
        for (VirtualFolder folder : this._vFolders.getFolders()) {
            file = new File(folder.getPath(), name);
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                raf.close();
                if (this._trackTime) {
                    this._loadTime = System.nanoTime() - start;
                }
                LOG.finer("Segment found by opening it " + file.getAbsolutePath());
                return file.getAbsolutePath();
            }
            catch (IOException e) {
            }
        }
        for (VirtualFolder folder : this._vFolders.getFolders()) {
            File dir = new File(folder.getPath());
            assert (dir.isDirectory()) : dir;
            try {
                File temp = File.createTempFile(".Cache", "Flusher", dir);
                temp.delete();
            }
            catch (IOException ex) {
                LOG.info("Could not create temp file in " + dir);
            }
        }
        if (this._trackTime) {
            this._loadTime = System.nanoTime() - start;
        }
        LOG.finer("Could not find segment " + name);
        return null;
    }

    public void load() throws SeisException {
        long start = System.nanoTime();
        if (this._vFolders.containPrecomputeExtents()) {
            String[] extentPathNames;
            for (String path : extentPathNames = this._vFolders.getExtentPathNames(this._extBaseName)) {
                ExtentListEntry e;
                File f = new File(path);
                String name = f.getName();
                int index = this.getIndexFromName(name);
                if (index < 0) continue;
                this._extents[index] = e = new ExtentListEntry(name, index, (long)index * this._extentSize, this._extentSize, f.getAbsolutePath());
            }
        } else {
            for (VirtualFolder folder : this._vFolders.getFolders()) {
                File[] files;
                File dir = new File(folder.getPath());
                if (!dir.exists()) continue;
                for (File f : files = dir.listFiles(new ExtentBaseNameFilter(this._extBaseName, EXCLUDE_EXTN))) {
                    String name = f.getName();
                    int index = this.getIndexFromName(name);
                    if (index < 0) continue;
                    ExtentListEntry e = new ExtentListEntry(name, index, (long)index * this._extentSize, this._extentSize, f.getAbsolutePath());
                    if (this._extents[index] != null) {
                        throw new SeisException("Duplicate Extent encountered\n" + e.getPath() + "\n" + this._extents[index].getPath());
                    }
                    this._extents[index] = e;
                }
            }
        }
        if (this._trackTime) {
            this._loadTime = System.nanoTime() - start;
        }
    }

    private int getIndexFromName(String name) {
        assert (name != null && name.length() > 0);
        int i = -1;
        String index = name.substring(this._extBaseName.length());
        try {
            i = Integer.parseInt(index);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "getIndexFrom name failure on " + name, e);
        }
        return i;
    }

    public ExtentListEntry[] getExtents() {
        return (ExtentListEntry[])this._extents.clone();
    }

    public void trackTime(boolean flag) {
        this._trackTime = flag;
    }

    public float getLockTime() {
        return 1.0E-9f * (float)this._lockTime;
    }

    public float getLoadTime() {
        return 1.0E-9f * this._loadTime;
    }

    static {
        LOG.config("Retry count for opening an existing extent is " + RETRIES);
    }
}

