/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.examples;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.util.Arrays;
import org.javaseis.array.MultiArray;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.Seisio;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.util.SeisException;

public class CreateRandomCDPs {
    public static void main(String[] args) throws SeisException {
        ParameterSet parset = ParameterSetIO.argsToParameters(args);
        String path = parset.getString("path", System.getProperty("user.home") + File.separator + "jsCreateTest");
        System.out.println("Create JavaSeis CDP dataset with random numbers\nPath: " + path);
        int[] size = parset.getInts("size", new int[]{250, 30, 11, 3});
        if (size.length != 4) {
            throw new RuntimeException("Wrong number of elements for size - should be 4");
        }
        System.out.println("Size: " + Arrays.toString(size));
        double[] deltas = parset.getDoubles("deltas", new double[]{4.0, 100.0, 25.0, 50.0});
        if (deltas.length != 4) {
            throw new RuntimeException("Wrong number of elements for deltas - should be 4");
        }
        long[] ldeltas = parset.getLongs("ldeltas", new long[]{4L, 4L, 1L, 2L});
        if (ldeltas.length != 4) {
            throw new RuntimeException("Wrong number of elements for ldeltas - should be 4");
        }
        double[] origins = parset.getDoubles("origins", new double[]{0.0, 0.0, 0.0, 0.0});
        if (origins.length != 4) {
            throw new RuntimeException("Wrong number of elements for origins - should be 4");
        }
        long[] lorigins = parset.getLongs("lorigins", new long[]{0L, 1L, 1L, 1L});
        if (lorigins.length != 4) {
            throw new RuntimeException("Wrong number of elements for lorigins - should be 4");
        }
        GridDefinition grid = GridDefinition.standardGrid(1, size, lorigins, ldeltas, origins, deltas);
        Seisio.delete(path);
        Seisio sio = new Seisio(path, grid);
        sio.create();
        System.out.println("Created " + path);
        MultiArray frm = MultiArray.factory(2, Float.TYPE, 1, size);
        float[] trc = new float[size[0]];
        int[] position = new int[4];
        for (int volume = 0; volume < size[3]; ++volume) {
            System.out.println("Writing volume " + volume + " ... ");
            position[3] = volume;
            for (int frame = 0; frame < size[2]; ++frame) {
                position[2] = frame;
                int trace = 0;
                while (trace < size[1]) {
                    ArrayMath.rand((float[])trc);
                    position[1] = trace++;
                    frm.putTrace(trc, position);
                }
                position[1] = 0;
                position[0] = 0;
                sio.writeMultiArray(frm, position);
            }
        }
        sio.close();
        System.out.println("Write complete");
    }
}

