/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta.test;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.CleanHandler;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.javaseis.array.TransposeType;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.PositionIterator;
import org.javaseis.array.beta.TraceIterator;
import org.javaseis.iterators.beta.IPositionIterator;
import org.junit.Assert;
import org.junit.Test;

public class JTestFlexArray2D {
    private static final Logger LOG = Logger.getLogger(JTestFlexArray2D.class.getName());

    public static <T> void modifyTraceValue(IFlexArray<T> ma) {
        int[] shape = ma.getShape();
        PositionIterator it = new PositionIterator(ma.getShape(), new int[ma.getDimensions()], IPositionIterator.Direction.FORWARD, 1);
        while (it.hasNext()) {
            int[] pos = it.next();
            T t = ma.getTrace(pos);
            for (int j = 0; j < shape[0]; ++j) {
                pos[0] = j;
                Number value = (Number)Array.get(t, j);
                value = ArrayMath.sum((int[])pos);
                if (ma.getElementType().equals(Integer.TYPE)) {
                    Array.set(t, j, value.intValue());
                    continue;
                }
                if (ma.getElementType().equals(Float.TYPE)) {
                    Array.set(t, j, Float.valueOf(value.floatValue()));
                    continue;
                }
                if (ma.getElementType().equals(Short.TYPE)) {
                    Array.set(t, j, value.shortValue());
                    continue;
                }
                if (ma.getElementType().equals(Long.TYPE)) {
                    Array.set(t, j, value.longValue());
                    continue;
                }
                if (ma.getElementType().equals(Double.TYPE)) {
                    Array.set(t, j, value.doubleValue());
                    continue;
                }
                if (ma.getElementType().equals(Byte.TYPE)) {
                    Array.set(t, j, value.byteValue());
                    continue;
                }
                if (!ma.getElementType().equals(Integer.class)) continue;
                Array.set(t, j, value);
            }
        }
    }

    public static <T> void validateData(IFlexArray<T> ma) {
        int[] shape = ma.getShape();
        IPositionIterator<int[]> it = ma.newPositionIterator();
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            T t = ma.getTrace(pos);
            for (int k = 0; k < shape[0]; ++k) {
                pos[0] = k;
                Number obj = (Number)Array.get(t, k);
                Assert.assertEquals((long)ArrayMath.sum((int[])pos), (long)obj.intValue());
            }
        }
    }

    @Test
    public void testGetTraceIO() {
        int[] shape = new int[]{11, 5};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
        }
    }

    @Test
    public void testReshape0() {
        int[] shape = new int[]{11, 5};
        int[] shape2 = new int[]{3, 5};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            aa.reshape(shape2);
            Assert.assertArrayEquals((int[])shape2, (int[])aa.getShape());
            JTestFlexArray2D.validateData(aa);
        }
    }

    @Test
    public void testReshape0Expand() {
        int[] shape = new int[]{11, 5};
        int[] shape2 = new int[]{15, 5};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            aa.reshape(shape2);
            Assert.assertArrayEquals((int[])shape2, (int[])aa.getShape());
            TraceIterator it = new TraceIterator(aa);
            while (it.hasNext()) {
                Object t = it.next();
                int[] pos = it.getPosition();
                for (int k = 0; k < shape2[0]; ++k) {
                    pos[0] = k;
                    Number obj = (Number)Array.get(t, k);
                    if (k < shape[0]) {
                        Assert.assertEquals((long)ArrayMath.sum((int[])pos), (long)obj.intValue());
                        continue;
                    }
                    Assert.assertEquals((long)0L, (long)obj.intValue());
                }
            }
            aa.reshape(shape);
            Assert.assertArrayEquals((int[])shape, (int[])aa.getShape());
            JTestFlexArray2D.validateData(aa);
        }
    }

    @Test
    public void testReshape1() {
        int[] shape = new int[]{11, 5};
        int[] shape2 = new int[]{11, 3};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            aa.reshape(shape2);
            Assert.assertArrayEquals((int[])shape2, (int[])aa.getShape());
            JTestFlexArray2D.validateData(aa);
        }
    }

    @Test
    public void testReshape1Expand() {
        int[] shape = new int[]{11, 5};
        int[] shape2 = new int[]{11, 7};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            aa.reshape(shape2);
            Assert.assertArrayEquals((int[])shape2, (int[])aa.getShape());
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
        }
    }

    @Test
    public void addDimension() {
        int[] shape = new int[]{11, 5};
        int[] shape2 = new int[]{11, 5, 3};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            aa.reshape(shape2);
            Assert.assertArrayEquals((int[])shape2, (int[])aa.getShape());
        }
    }

    @Test
    public void testT21() {
        int[] shape = new int[]{11, 5};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            aa.transpose(TransposeType.T21);
            if (aa.getElementCount() == 1) {
                JTestFlexArray2D.validateData(aa);
                continue;
            }
            LOG.warning("Need to validate results for complex data");
        }
    }

    @Test
    public void testTCopyConstructor() {
        int[] shape = new int[]{11, 5};
        int[] shape2 = new int[]{1, 5};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            FlexArray bb = new FlexArray((FlexArray)aa);
            JTestFlexArray2D.validateData(bb);
            bb.reshape(shape2);
            JTestFlexArray2D.validateData(bb);
            Assert.assertArrayEquals((int[])shape, (int[])aa.getShape());
            Assert.assertArrayEquals((int[])shape2, (int[])bb.getShape());
        }
    }

    private List<IFlexArray> getTestArrays(int[] shape) {
        ArrayList<IFlexArray> list = new ArrayList<IFlexArray>();
        list.add(FlexArray.createIntArray(shape));
        list.add(FlexArray.createFloatArray(shape));
        list.add(FlexArray.createIntArray(1, shape));
        list.add(FlexArray.createFloatArray(1, shape));
        list.add(new FlexArray(long[].class, 1, shape));
        list.add(new FlexArray(short[].class, 1, shape));
        list.add(new FlexArray(double[].class, 1, shape));
        list.add(new FlexArray(byte[].class, 1, shape));
        list.add(FlexArray.createIntArray(2, shape));
        list.add(FlexArray.createFloatArray(2, shape));
        return list;
    }

    static {
        CleanHandler.setDefaultHandler();
    }
}

