/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.scheme.CryptoTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public final class DHPublicKeyValidate
extends CryptoTransform
implements Serializable {
    private static final long serialVersionUID = 8328188657781466902L;
    private BigInteger a;
    private BigInteger b;

    public DHPublicKeyValidate() {
        super("DHPublicKeyValidation");
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        if (n2 != 5 || objectArray == null || objectArray.length < 2) {
            throw new IllegalArgumentException("wrong params");
        }
        super.init(n2, objectArray, random);
        if (objectArray[0] instanceof BigInteger && objectArray[1] instanceof BigInteger) {
            this.a = (BigInteger)objectArray[0];
            this.b = (BigInteger)objectArray[1];
        } else if (objectArray[0] instanceof byte[] && objectArray[1] instanceof byte[]) {
            this.a = new BigInteger(1, (byte[])objectArray[0]);
            this.b = new BigInteger(1, (byte[])objectArray[1]);
        } else {
            throw new IllegalArgumentException("wrong parameters");
        }
    }

    public Object transformToObject(byte[] byArray, int n2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        Object object;
        if (byArray == null || n2 + n3 > byArray.length) {
            throw new IllegalStateException("wrong input parameter");
        }
        boolean bl2 = false;
        BigInteger bigInteger = null;
        if (n2 == 0 && n3 == byArray.length) {
            bigInteger = new BigInteger(1, byArray);
        } else {
            object = new byte[n3];
            System.arraycopy(byArray, n2, object, 0, n3);
            bigInteger = new BigInteger(1, (byte[])object);
        }
        object = BigInteger.ONE;
        BigInteger bigInteger2 = ((BigInteger)object).add((BigInteger)object);
        boolean bl3 = bl2 = bigInteger.compareTo(bigInteger2) >= 0;
        if (bl2) {
            boolean bl4 = bl2 = bigInteger.compareTo(this.a.subtract(bigInteger2)) <= 0;
        }
        if (bl2) {
            bl2 = bigInteger.modPow(this.b, this.a).compareTo((BigInteger)object) == 0;
        }
        return new Boolean(bl2);
    }

    public int outputSize(int n2, boolean bl) {
        return n2;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        return 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeObject(this.b);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (BigInteger)objectInputStream.readObject();
        this.b = (BigInteger)objectInputStream.readObject();
    }
}

