/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.rsa;

import com.certicom.ecc.rsa.RSAException;
import com.certicom.ecc.rsa.RSAKey;
import com.certicom.ecc.rsa.RSAPrimitive;
import com.certicom.ecc.rsa.RSAPrivateKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;

public final class RSADP
extends RSAPrimitive
implements Serializable {
    private static final long serialVersionUID = -7307009034924835879L;
    RSAPrivateKey a;

    public RSADP(RSAPrivateKey rSAPrivateKey) {
        this.a = rSAPrivateKey;
    }

    public void reset() {
        this.a = null;
    }

    public void setKey(RSAKey rSAKey) {
        if (!(rSAKey instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException("not private key.");
        }
        this.a = (RSAPrivateKey)rSAKey;
    }

    public BigInteger calc(BigInteger bigInteger) throws RSAException {
        if (this.a == null) {
            throw new RSAException("no private key");
        }
        if (this.a.hasExponents()) {
            this.a(bigInteger, this.a.n());
        } else {
            this.a(bigInteger, this.a.p().multiply(this.a.q()));
        }
        if (this.a.hasCRT()) {
            byte[] byArray;
            BigInteger bigInteger2 = new BigInteger("1");
            BigInteger bigInteger3 = bigInteger.mod(this.a.p());
            byte[] byArray2 = bigInteger3.xor(this.a.p()).toByteArray();
            if (byArray2.length < 64) {
                byArray = new byte[64];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            } else {
                byArray = byArray2;
            }
            for (int i2 = 64; i2 < byArray.length; ++i2) {
                int n2 = i2;
                byArray[n2] = (byte)(byArray[n2] ^ byArray[i2 - 64]);
            }
            CryptoTransform cryptoTransform = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "SHA-1");
            cryptoTransform.init(5, null, null);
            byte[] byArray3 = cryptoTransform.transform(byArray, byArray.length - 64, 64, true);
            BigInteger bigInteger4 = new BigInteger(1, byArray3);
            BigInteger bigInteger5 = bigInteger4.modPow(this.a.eP().subtract(bigInteger2), this.a.p());
            BigInteger bigInteger6 = bigInteger5.multiply(bigInteger3).mod(this.a.p());
            BigInteger bigInteger7 = bigInteger6.multiply(bigInteger4).mod(this.a.p()).modPow(this.a.dP().subtract(bigInteger2), this.a.p());
            BigInteger bigInteger8 = bigInteger7.multiply(bigInteger6).mod(this.a.p());
            bigInteger3 = bigInteger.mod(this.a.q());
            bigInteger5 = bigInteger4.modPow(this.a.eQ().subtract(bigInteger2), this.a.q());
            bigInteger6 = bigInteger5.multiply(bigInteger3).mod(this.a.q());
            bigInteger7 = bigInteger6.multiply(bigInteger4).mod(this.a.q()).modPow(this.a.dQ().subtract(bigInteger2), this.a.q());
            BigInteger bigInteger9 = bigInteger7.multiply(bigInteger6).mod(this.a.q());
            BigInteger bigInteger10 = this.a.qInv().multiply(bigInteger8.subtract(bigInteger9)).mod(this.a.p());
            return bigInteger9.add(bigInteger10.multiply(this.a.q()));
        }
        return bigInteger.modPow(this.a.d(), this.a.n());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (RSAPrivateKey)objectInputStream.readObject();
    }
}

