/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import org.javaseis.io.Seisio;
import org.javaseis.server.SocketCommands;
import org.javaseis.util.SeisException;

public class SocketServer {
    private ServerSocket _serverSocket;
    private Seisio _seisio;
    private String _path;
    private Socket _socket;
    private DataInputStream _in;
    private DataOutputStream _out;

    private void init(int port) throws IOException {
        this._serverSocket = new ServerSocket(port);
    }

    private void openDataset(String path) throws SeisException {
        this._path = path;
        this._seisio = new Seisio(path);
        this._seisio.open("rw");
    }

    private void closeDataset() throws SeisException {
        if (this._seisio != null) {
            this._seisio.close();
        }
    }

    private void acceptConnection() {
        try {
            this._socket = this._serverSocket.accept();
            this._out = new DataOutputStream(this._socket.getOutputStream());
            this._in = new DataInputStream(this._socket.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void closeConnections() {
        try {
            if (this._socket != null) {
                this._socket.close();
            }
            System.exit(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean listen() {
        System.out.println("Starting to listen");
        boolean done = false;
        boolean exit = true;
        try {
            block11: while (!done) {
                int c = SocketCommands.getCommand(this._in);
                if (c == -1) return exit;
                switch (c) {
                    case 101: {
                        this._out.writeUTF(Seisio.getDescription(this._path));
                        System.out.println("getDescName");
                        continue block11;
                    }
                    case 201: {
                        long[] keys = SocketCommands.getKeys(this._seisio.getGridDefinition().getNumDimensions(), this._in);
                        Arrays.toString(keys);
                        int[] position = new int[]{0, 0, 0, 0};
                        for (int i = 2; i < keys.length; ++i) {
                            position[i] = (int)this._seisio.findLogicalIndex(i, keys[i]);
                        }
                        int fold = this._seisio.readFrame(position);
                        float[][] traces = this._seisio.getTraceDataArray();
                        SocketCommands.sendTraces(this._in, this._out, traces, fold);
                        continue block11;
                    }
                    case 301: {
                        System.out.println("getDataDimensions");
                        this._out.writeInt(this._seisio.getGridDefinition().getNumDimensions());
                        continue block11;
                    }
                    case 401: {
                        System.out.println("sendDimensionProperties");
                        SocketCommands.sendDimensionProperties(this._in, this._out, this._seisio);
                        continue block11;
                    }
                    case 701: {
                        System.out.println("openDataset");
                        this.closeDataset();
                        String path = SocketCommands.getDatasetPath(this._in);
                        this.openDataset(path);
                        continue block11;
                    }
                    case 501: {
                        System.out.println("Disconnect");
                        return false;
                    }
                    case -999: {
                        System.out.println("Exit");
                        System.out.flush();
                        done = true;
                        continue block11;
                    }
                }
                System.out.println(c);
            }
            return exit;
        }
        catch (IOException e) {
            System.out.println("Exception caught during listen");
            return false;
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("Usage port datasetPath (datasetPath is optional)");
        }
        if (args.length == 1) {
            System.out.println("SocketServer args: " + args[0]);
        } else if (args.length == 2) {
            System.out.println("SocketServer args: " + args[0] + " Path: " + args[1]);
        }
        SocketServer ss = new SocketServer();
        Integer port = new Integer(args[0]);
        ss.init(port);
        if (args.length == 2) {
            ss.openDataset(args[1]);
        }
        System.out.println("waiting for connection");
        boolean exit = false;
        while (!exit) {
            ss.acceptConnection();
            exit = ss.listen();
        }
        ss.closeConnections();
        ss.closeDataset();
    }
}

