/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.JSUtilFile;
import org.javaseis.io.VirtualFolder;
import org.javaseis.io.VirtualFolders;
import org.javaseis.util.SeisException;

public class ExtentPolicyRandom
implements ExtentPolicy {
    public static final String ID = "RANDOM";
    private static final String GLOBAL_REQUIRED_FREE_SPACE = "GLOBAL_REQUIRED_FREE_SPACE";
    private long _globalMinFreeSpace = 0L;
    private static final Logger LOG = Logger.getLogger(ExtentPolicyRandom.class.getName());

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public int getNextExtentFolder(int index, int maxNumExtents, VirtualFolders vFolders) {
        ArrayList<Integer> targets = new ArrayList<Integer>();
        int r = -1;
        Integer[] indexes = vFolders.getIndexes(VirtualFolder.Attribute.READ_WRITE);
        VirtualFolder[] folders = vFolders.getFolders();
        for (int i = 0; i < indexes.length; ++i) {
            File f = new File(folders[indexes[i]].getPath());
            if (!f.exists()) {
                f = f.getParentFile();
            }
            if (!f.exists()) {
                f = f.getParentFile();
            }
            if (!f.exists()) {
                f = f.getParentFile();
            }
            long space = JSUtilFile.diskCapacityBytes(f.getAbsolutePath());
            if ((space = (long)((double)space * 0.98)) <= this._globalMinFreeSpace && this._globalMinFreeSpace != 0L) continue;
            targets.add(indexes[i]);
        }
        if (targets.size() == 0) {
            Integer[] o_indexes = vFolders.getIndexes(VirtualFolder.Attribute.OVERFLOW_ONLY);
            if (o_indexes.length > 0) {
                int o_indexes_index = vFolders.getPsuedoRandom(index, o_indexes.length);
                r = o_indexes[o_indexes_index];
            }
            if (r == -1) {
                LOG.severe("ExtentPolicy - Random - was unable to find any folders that have READ_WRITE attributes and sufficient available free space and NO OVERFLOW folders were found. Check the folders and minimum disk space specifications shown in the JavaSeis Secondary Storage list from the Project Properties dialog.");
            } else {
                LOG.severe("ExtentPolicy - Random - was unable to find any folders that have READ_WRITE attributes and sufficient available free space, using overflow folder: " + folders[r]);
            }
            this.dumpState(vFolders);
            return r;
        }
        r = vFolders.getPsuedoRandom(index, targets.size());
        return (Integer)targets.get(r);
    }

    private void dumpState(VirtualFolders vFolders) {
        StringBuffer buf = new StringBuffer();
        buf.append("GLOBAL_REQUIRED_FREE_SPACE: " + this._globalMinFreeSpace + "\n");
        for (VirtualFolder folder : vFolders.getFolders()) {
            File f = new File(folder.getPath());
            if (!f.exists()) {
                f = f.getParentFile();
            }
            if (!f.exists()) {
                f = f.getParentFile();
            }
            if (!f.exists()) {
                f = f.getParentFile();
            }
            long space = JSUtilFile.diskCapacityBytes(f.getAbsolutePath());
            buf.append(folder.getPath());
            buf.append("," + (Object)((Object)folder.getAttribute()));
            buf.append(", free space: " + space);
            buf.append("\n");
        }
        LOG.severe(buf.toString());
    }

    public void setGlobalMinFreeSpace(long minSpaceBytes) {
        this._globalMinFreeSpace = minSpaceBytes;
    }

    @Override
    public void store(ParameterSet parameterSet) throws SeisException {
        parameterSet.setString("POLICY_ID", this.getID());
        parameterSet.setLong(GLOBAL_REQUIRED_FREE_SPACE, this._globalMinFreeSpace);
    }

    @Override
    public void load(ParameterSet parameterSet) {
        this._globalMinFreeSpace = parameterSet.getLong(GLOBAL_REQUIRED_FREE_SPACE, this._globalMinFreeSpace);
    }

    @Override
    public String getHelp() {
        return "Randomize the extents over the available filesystems specifed for secondary storage";
    }
}

