/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.JSUtilFile;
import org.javaseis.io.VirtualFolder;
import org.javaseis.io.VirtualFolders;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.util.SeisException;

public class ExtentPolicyMinMax
implements ExtentPolicy {
    private static final String MIN_FREE_SPACE = "MIN_FREE_SPACE";
    private static final String MAX_FREE_SPACE = "MAX_FREE_SPACE";
    public static final String ID = "MIN_MAX";
    private static final Logger LOG = Logger.getLogger(ExtentPolicyMinMax.class.getName());
    private long _minFreeSpace = 0x280000000L;
    private long _maxFreeSpace = 80530636800L;

    public void setMinMaxSpace(long minSpaceBytes, long maxSpaceBytes) {
        if (maxSpaceBytes < minSpaceBytes) {
            throw new IllegalArgumentException("minSpace must be larger than maxSpace");
        }
        this._minFreeSpace = minSpaceBytes;
        this._maxFreeSpace = maxSpaceBytes;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public int getNextExtentFolder(int index, int maxNumExtents, VirtualFolders vFolders) {
        ArrayList<Integer> targets = new ArrayList<Integer>();
        int r = -1;
        Integer[] indexes = vFolders.getIndexes(VirtualFolder.Attribute.READ_WRITE);
        VirtualFolder[] folders = vFolders.getFolders();
        for (int i = 0; i < indexes.length; ++i) {
            File f = new File(folders[indexes[i]].getPath());
            if (!f.exists()) {
                f = f.getParentFile();
            }
            if (!f.exists()) {
                f = f.getParentFile();
            }
            if (!f.exists()) {
                f = f.getParentFile();
            }
            long space = JSUtilFile.diskCapacityBytes(f.getAbsolutePath());
            if ((space = (long)((double)space * 0.98)) > this._minFreeSpace) {
                targets.add(indexes[i]);
            }
            if (space <= this._maxFreeSpace) continue;
            targets.add(indexes[i]);
        }
        if (targets.size() == 0) {
            Integer[] o_indexes = vFolders.getIndexes(VirtualFolder.Attribute.OVERFLOW_ONLY);
            if (o_indexes.length > 0) {
                int o_indexes_index = vFolders.getPsuedoRandom(index, o_indexes.length);
                r = o_indexes[o_indexes_index];
            }
            if (r == -1) {
                LOG.severe("ExtentPolicy - MinMax - was unable to find any folders that have READ_WRITE attributes and sufficient available free space and NO OVERFLOW folders were found. Check the folders and minimum disk space specifications shown in the JavaSeis Secondary Storage list from the Project Properties dialog.");
            } else {
                LOG.severe("ExtentPolicy - MinMax - was unable to find any folders that have READ_WRITE attributes and sufficient available free space, using overflow folder: " + folders[r]);
            }
            this.dumpState(vFolders);
            return r;
        }
        r = vFolders.getPsuedoRandom(index, targets.size());
        return (Integer)targets.get(r);
    }

    private void dumpState(VirtualFolders vFolders) {
        StringBuffer buf = new StringBuffer();
        buf.append("MIN_FREE_SPACE: " + this._minFreeSpace + "\n");
        buf.append("MAX_FREE_SPACE: " + this._maxFreeSpace + "\n");
        for (VirtualFolder folder : vFolders.getFolders()) {
            File f = new File(folder.getPath());
            if (!f.exists()) {
                f = f.getParentFile();
            }
            if (!f.exists()) {
                f = f.getParentFile();
            }
            if (!f.exists()) {
                f = f.getParentFile();
            }
            long space = JSUtilFile.diskCapacityBytes(f.getAbsolutePath());
            buf.append(folder.getPath());
            buf.append("," + (Object)((Object)folder.getAttribute()));
            buf.append(", free space: " + space);
            buf.append("\n");
        }
        LOG.severe(buf.toString());
    }

    @Override
    public void store(ParameterSet parameterSet) throws SeisException {
        parameterSet.setString("POLICY_ID", this.getID());
        parameterSet.setLong(MIN_FREE_SPACE, this._minFreeSpace);
        parameterSet.setLong(MAX_FREE_SPACE, this._maxFreeSpace);
    }

    @Override
    public void load(ParameterSet parameterSet) throws SeisException {
        this._minFreeSpace = ParameterSetIO.getRequiredLong(parameterSet, MIN_FREE_SPACE);
        this._maxFreeSpace = ParameterSetIO.getRequiredLong(parameterSet, MAX_FREE_SPACE);
    }

    @Override
    public String getHelp() {
        return "Preferentially use large file systems for extents - as per Min and Max allocation properties";
    }
}

