/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta.test;

import edu.mines.jtk.util.CleanHandler;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.javaseis.array.beta.ArraysUtil;
import org.junit.Test;

public class JTestArraysReshape {
    private static final Logger LOG = Logger.getLogger(JTestArraysReshape.class.getName());

    @Test
    public void testGetArrayDiminsions() {
        int[] i1 = new int[1];
        Assert.assertEquals((int)1, (int)ArraysUtil.getDimensions(i1));
        float[] f1 = new float[1];
        Assert.assertEquals((int)1, (int)ArraysUtil.getDimensions(f1));
        float[] f10 = new float[]{};
        Assert.assertEquals((int)1, (int)ArraysUtil.getDimensions(f10));
        int[][] i2 = new int[1][1];
        Assert.assertEquals((int)2, (int)ArraysUtil.getDimensions(i2));
        int[][] i2a = new int[1][];
        Assert.assertEquals((int)2, (int)ArraysUtil.getDimensions(i2a));
        Object[] o = new Object[1];
        Assert.assertEquals((int)1, (int)ArraysUtil.getDimensions(o));
        Assert.assertEquals((int)0, (int)ArraysUtil.getDimensions(new Object()));
    }

    @Test
    public void testIntSetLength1() {
        int[][] in = new int[11][1001];
        int[][] out = ArraysUtil.setLength1(in, 500);
        Assert.assertEquals((int)500, (int)out.length);
        int[][] out2 = ArraysUtil.setLength1(in, 2002);
        Assert.assertEquals((int)2002, (int)out2.length);
    }

    @Test
    public void testFloatSetLength1() {
        float[][] in = new float[11][1001];
        float[][] out = ArraysUtil.setLength1(in, 500);
        Assert.assertEquals((int)500, (int)out.length);
        float[][] out2 = ArraysUtil.setLength1(in, 2002);
        Assert.assertEquals((int)2002, (int)out2.length);
    }

    @Test
    public void testFloatSetLength1b() {
        float[][][] in = new float[11][13][1001];
        float[][][] out = ArraysUtil.setLength1(in, 500);
        Assert.assertEquals((int)500, (int)out[0].length);
        float[][][] out2 = ArraysUtil.setLength1(in, 2002);
        Assert.assertEquals((int)2002, (int)out2[0].length);
    }

    static {
        CleanHandler.setDefaultHandler();
    }
}

