/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.lictext.FeatureLine;
import com.macrovision.flexlm.lictext.LicenseElement;
import com.macrovision.flexlm.lictext.OtherLine;
import com.macrovision.flexlm.lictext.PackageLine;
import com.macrovision.flexlm.lictext.ServerLine;
import com.macrovision.flexlm.lictext.TokenizedLicenseLine;
import com.macrovision.flexlm.lictext.UpgradeLine;
import com.macrovision.flexlm.lictext.VendorLine;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;

public class LicenseCertificate
implements FlexlmConstants,
FlexlmInternalConstants {
    private VendorInfo vInfo;
    private LinkedList elementExceptions;
    private ArrayList allElements;
    private String filename;
    private LinkedList servers;
    private LinkedList vendors;
    private LinkedList features;
    private LinkedList upgrades;
    private LinkedList packages;
    private LinkedList authenticatedFeatures;
    private LinkedList authenticatedUpgrades;
    private LinkedList authenticatedPackages;
    private boolean useServer;
    private static final String LINE_SEP = System.getProperty("line.separator");

    public LicenseCertificate(Reader reader, String string, VendorInfo vendorInfo) throws IOException {
        this.vInfo = vendorInfo;
        this.filename = string;
        LinkedList linkedList = LicenseCertificate.parseStream(reader, string);
        this.processLicenseLines(linkedList);
    }

    private static LinkedList parseStream(Reader reader, String string) throws IOException {
        TokenizedLicenseLine tokenizedLicenseLine;
        LinkedList<TokenizedLicenseLine> linkedList = new LinkedList<TokenizedLicenseLine>();
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        while ((tokenizedLicenseLine = new TokenizedLicenseLine(lineNumberReader, string)).hasContent()) {
            linkedList.add(tokenizedLicenseLine);
        }
        return linkedList;
    }

    private void processLicenseLines(LinkedList linkedList) {
        this.allElements = new ArrayList();
        this.servers = new LinkedList();
        this.vendors = new LinkedList();
        this.packages = new LinkedList();
        this.features = new LinkedList();
        this.upgrades = new LinkedList();
        this.elementExceptions = new LinkedList();
        this.allElements.ensureCapacity(linkedList.size());
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            TokenizedLicenseLine tokenizedLicenseLine = (TokenizedLicenseLine)listIterator.next();
            LicenseElement licenseElement = null;
            try {
                licenseElement = this.createElement(tokenizedLicenseLine);
            }
            catch (FlexlmException flexlmException) {
                this.elementExceptions.add(flexlmException);
                licenseElement = new OtherLine(tokenizedLicenseLine);
            }
            this.allElements.add(licenseElement);
            this.addToTypeList(licenseElement);
        }
        this.setLmgrdPort();
    }

    private void setLmgrdPort() {
        int n = 0;
        if (this.servers.size() > 0 && this.vendors.size() > 0) {
            ServerLine serverLine = (ServerLine)this.servers.getFirst();
            n = serverLine.getPortNumber();
            ListIterator listIterator = this.vendors.listIterator(0);
            while (listIterator.hasNext()) {
                VendorLine vendorLine = (VendorLine)listIterator.next();
                vendorLine.setLmgrdPort(n);
            }
        }
    }

    private LicenseElement createElement(TokenizedLicenseLine tokenizedLicenseLine) throws FlexlmException {
        int n = this.getLineType(tokenizedLicenseLine);
        LicenseElement licenseElement = null;
        switch (n) {
            case 1: {
                ServerLine serverLine = new ServerLine(tokenizedLicenseLine, this, this.vInfo);
                licenseElement = serverLine;
                break;
            }
            case 2: {
                VendorLine vendorLine = new VendorLine(tokenizedLicenseLine, this, this.vInfo);
                licenseElement = vendorLine;
                break;
            }
            case 3: {
                PackageLine packageLine = new PackageLine(tokenizedLicenseLine, this, this.vInfo);
                licenseElement = packageLine;
                break;
            }
            case 4: {
                FeatureLine featureLine = new FeatureLine(tokenizedLicenseLine, this, this.vInfo);
                licenseElement = featureLine;
                break;
            }
            case 5: {
                UpgradeLine upgradeLine = new UpgradeLine(tokenizedLicenseLine, this, this.vInfo);
                licenseElement = upgradeLine;
                break;
            }
            case 6: {
                this.useServer = true;
            }
            default: {
                OtherLine otherLine;
                licenseElement = otherLine = new OtherLine(tokenizedLicenseLine);
            }
        }
        return licenseElement;
    }

    private void addToTypeList(LicenseElement licenseElement) {
        if (licenseElement instanceof ServerLine) {
            this.servers.add(licenseElement);
        } else if (licenseElement instanceof VendorLine) {
            this.vendors.add(licenseElement);
        } else if (licenseElement instanceof PackageLine) {
            this.packages.add(licenseElement);
        } else if (licenseElement instanceof UpgradeLine) {
            this.upgrades.add(licenseElement);
        } else if (licenseElement instanceof FeatureLine) {
            this.features.add(licenseElement);
        }
    }

    protected int getLineType(TokenizedLicenseLine tokenizedLicenseLine) {
        return tokenizedLicenseLine.getType();
    }

    public boolean authenticate(boolean bl) {
        this.authenticatedFeatures = new LinkedList();
        this.authenticatedPackages = new LinkedList();
        this.authenticatedUpgrades = new LinkedList();
        boolean bl2 = this.authenticateList(this.authenticatedFeatures, this.features, bl);
        boolean bl3 = this.authenticateList(this.authenticatedPackages, this.packages, bl);
        boolean bl4 = this.authenticateList(this.authenticatedUpgrades, this.upgrades, bl);
        return bl2 | bl3 | bl4;
    }

    public boolean authenticate() {
        return this.authenticate(true);
    }

    private boolean authenticateList(LinkedList linkedList, LinkedList linkedList2, boolean bl) {
        boolean bl2 = false;
        ListIterator listIterator = linkedList2.listIterator(0);
        while (listIterator.hasNext()) {
            LicenseElement licenseElement = (LicenseElement)listIterator.next();
            try {
                if (bl) {
                    licenseElement.authenticate();
                }
                linkedList.add(licenseElement);
                bl2 = true;
            }
            catch (FlexlmException flexlmException) {
                this.elementExceptions.add(flexlmException);
            }
        }
        return bl2;
    }

    public LinkedList getElementExceptions() {
        return this.elementExceptions;
    }

    public LinkedList getServers() {
        return this.servers;
    }

    public LinkedList getVendors() {
        return this.vendors;
    }

    public LinkedList getFeatures() {
        return this.features;
    }

    public LinkedList getAuthenticFeatures() {
        return this.authenticatedFeatures;
    }

    public LinkedList getUpgrades() {
        return this.upgrades;
    }

    public LinkedList getAuthenticUpgrades() {
        return this.authenticatedUpgrades;
    }

    public LinkedList getPackages() {
        return this.packages;
    }

    public LinkedList getAuthenticPackages() {
        return this.authenticatedPackages;
    }

    public boolean useServerPresent() {
        return this.useServer;
    }

    public LicenseElement appendElement(String string) throws FlexlmException {
        return this.addElement(string, -1);
    }

    public void appendElement(LicenseElement licenseElement) {
        this.addElement(licenseElement, -1);
    }

    private LicenseElement addElement(String string, int n) throws FlexlmException {
        LicenseElement licenseElement = this.createLicenseElement(string);
        this.addElement(licenseElement, n);
        return licenseElement;
    }

    private void addElement(LicenseElement licenseElement, int n) {
        this.allElements.ensureCapacity(this.allElements.size() + 1);
        if (n < 0) {
            n = this.allElements.size();
        }
        this.allElements.add(n, licenseElement);
        this.addToTypeList(licenseElement);
        this.setLmgrdPort();
    }

    public LicenseElement createLicenseElement(String string) throws FlexlmException {
        Object object;
        LinkedList linkedList = null;
        try {
            object = new StringReader(string);
            linkedList = LicenseCertificate.parseStream((Reader)object, null);
        }
        catch (IOException iOException) {
            throw new FlexlmException(-30, 4058);
        }
        object = this.createElement((TokenizedLicenseLine)linkedList.getFirst());
        return object;
    }

    public void write(String string) throws FlexlmException {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (SecurityException securityException) {
            throw new FlexlmException(-528, 4054);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FlexlmException(-528, 4055);
        }
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        ListIterator listIterator = this.allElements.listIterator(0);
        while (listIterator.hasNext()) {
            LicenseElement licenseElement = (LicenseElement)listIterator.next();
            try {
                String string2 = licenseElement.getRawLineText();
                if (string2 == null || licenseElement.isDirty()) {
                    string2 = LicenseElement.printableString(licenseElement.toString()) + LINE_SEP;
                }
                outputStreamWriter.write(string2, 0, string2.length());
            }
            catch (IOException iOException) {
                throw new FlexlmException(-528, 4056);
            }
        }
        try {
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new FlexlmException(-528, 4057);
        }
    }

    public void write() throws FlexlmException {
        this.write(this.filename);
    }

    public void deleteElement(LicenseElement licenseElement) throws FlexlmException {
        int n = this.allElements.indexOf(licenseElement);
        if (n < 0) {
            throw new FlexlmException(-5, 7026);
        }
        this.allElements.remove(n);
    }
}

